package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindOrderedServiceList invokes the csb.FindOrderedServiceList API synchronously
// api document: https://help.aliyun.com/api/csb/findorderedservicelist.html
func (client *Client) FindOrderedServiceList(request *FindOrderedServiceListRequest) (response *FindOrderedServiceListResponse, err error) {
	response = CreateFindOrderedServiceListResponse()
	err = client.DoAction(request, response)
	return
}

// FindOrderedServiceListWithChan invokes the csb.FindOrderedServiceList API asynchronously
// api document: https://help.aliyun.com/api/csb/findorderedservicelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindOrderedServiceListWithChan(request *FindOrderedServiceListRequest) (<-chan *FindOrderedServiceListResponse, <-chan error) {
	responseChan := make(chan *FindOrderedServiceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindOrderedServiceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindOrderedServiceListWithCallback invokes the csb.FindOrderedServiceList API asynchronously
// api document: https://help.aliyun.com/api/csb/findorderedservicelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindOrderedServiceListWithCallback(request *FindOrderedServiceListRequest, callback func(response *FindOrderedServiceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindOrderedServiceListResponse
		var err error
		defer close(result)
		response, err = client.FindOrderedServiceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindOrderedServiceListRequest is the request struct for api FindOrderedServiceList
type FindOrderedServiceListRequest struct {
	*requests.RpcRequest
	ProjectName         string           `position:"Query" name:"ProjectName"`
	ShowDelOrder        requests.Boolean `position:"Query" name:"ShowDelOrder"`
	CsbId               requests.Integer `position:"Query" name:"CsbId"`
	PageNum             requests.Integer `position:"Query" name:"PageNum"`
	CredentialGroupName string           `position:"Query" name:"CredentialGroupName"`
	AccessKey           string           `position:"Query" name:"AccessKey"`
	PageSize            requests.Integer `position:"Query" name:"PageSize"`
	ServiceName         string           `position:"Query" name:"ServiceName"`
	ServiceId           requests.Integer `position:"Query" name:"ServiceId"`
	ProjectId           requests.Integer `position:"Query" name:"ProjectId"`
}

// FindOrderedServiceListResponse is the response struct for api FindOrderedServiceList
type FindOrderedServiceListResponse struct {
	*responses.BaseResponse
	Code      int                          `json:"Code" xml:"Code"`
	Message   string                       `json:"Message" xml:"Message"`
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Data      DataInFindOrderedServiceList `json:"Data" xml:"Data"`
}

// CreateFindOrderedServiceListRequest creates a request to invoke FindOrderedServiceList API
func CreateFindOrderedServiceListRequest() (request *FindOrderedServiceListRequest) {
	request = &FindOrderedServiceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "FindOrderedServiceList", "", "")
	request.Method = requests.GET
	return
}

// CreateFindOrderedServiceListResponse creates a response to parse from FindOrderedServiceList response
func CreateFindOrderedServiceListResponse() (response *FindOrderedServiceListResponse) {
	response = &FindOrderedServiceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
