package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTagsForPrivateAccessApplication invokes the csas.ListTagsForPrivateAccessApplication API synchronously
func (client *Client) ListTagsForPrivateAccessApplication(request *ListTagsForPrivateAccessApplicationRequest) (response *ListTagsForPrivateAccessApplicationResponse, err error) {
	response = CreateListTagsForPrivateAccessApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// ListTagsForPrivateAccessApplicationWithChan invokes the csas.ListTagsForPrivateAccessApplication API asynchronously
func (client *Client) ListTagsForPrivateAccessApplicationWithChan(request *ListTagsForPrivateAccessApplicationRequest) (<-chan *ListTagsForPrivateAccessApplicationResponse, <-chan error) {
	responseChan := make(chan *ListTagsForPrivateAccessApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTagsForPrivateAccessApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTagsForPrivateAccessApplicationWithCallback invokes the csas.ListTagsForPrivateAccessApplication API asynchronously
func (client *Client) ListTagsForPrivateAccessApplicationWithCallback(request *ListTagsForPrivateAccessApplicationRequest, callback func(response *ListTagsForPrivateAccessApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTagsForPrivateAccessApplicationResponse
		var err error
		defer close(result)
		response, err = client.ListTagsForPrivateAccessApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTagsForPrivateAccessApplicationRequest is the request struct for api ListTagsForPrivateAccessApplication
type ListTagsForPrivateAccessApplicationRequest struct {
	*requests.RpcRequest
	ApplicationIds *[]string `position:"Query" name:"ApplicationIds"  type:"Repeated"`
	SourceIp       string    `position:"Query" name:"SourceIp"`
}

// ListTagsForPrivateAccessApplicationResponse is the response struct for api ListTagsForPrivateAccessApplication
type ListTagsForPrivateAccessApplicationResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	Applications []Application `json:"Applications" xml:"Applications"`
}

// CreateListTagsForPrivateAccessApplicationRequest creates a request to invoke ListTagsForPrivateAccessApplication API
func CreateListTagsForPrivateAccessApplicationRequest() (request *ListTagsForPrivateAccessApplicationRequest) {
	request = &ListTagsForPrivateAccessApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListTagsForPrivateAccessApplication", "", "")
	request.Method = requests.GET
	return
}

// CreateListTagsForPrivateAccessApplicationResponse creates a response to parse from ListTagsForPrivateAccessApplication response
func CreateListTagsForPrivateAccessApplicationResponse() (response *ListTagsForPrivateAccessApplicationResponse) {
	response = &ListTagsForPrivateAccessApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
