package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivateAccessApplicationsForDynamicRoute invokes the csas.ListPrivateAccessApplicationsForDynamicRoute API synchronously
func (client *Client) ListPrivateAccessApplicationsForDynamicRoute(request *ListPrivateAccessApplicationsForDynamicRouteRequest) (response *ListPrivateAccessApplicationsForDynamicRouteResponse, err error) {
	response = CreateListPrivateAccessApplicationsForDynamicRouteResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivateAccessApplicationsForDynamicRouteWithChan invokes the csas.ListPrivateAccessApplicationsForDynamicRoute API asynchronously
func (client *Client) ListPrivateAccessApplicationsForDynamicRouteWithChan(request *ListPrivateAccessApplicationsForDynamicRouteRequest) (<-chan *ListPrivateAccessApplicationsForDynamicRouteResponse, <-chan error) {
	responseChan := make(chan *ListPrivateAccessApplicationsForDynamicRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivateAccessApplicationsForDynamicRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivateAccessApplicationsForDynamicRouteWithCallback invokes the csas.ListPrivateAccessApplicationsForDynamicRoute API asynchronously
func (client *Client) ListPrivateAccessApplicationsForDynamicRouteWithCallback(request *ListPrivateAccessApplicationsForDynamicRouteRequest, callback func(response *ListPrivateAccessApplicationsForDynamicRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivateAccessApplicationsForDynamicRouteResponse
		var err error
		defer close(result)
		response, err = client.ListPrivateAccessApplicationsForDynamicRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivateAccessApplicationsForDynamicRouteRequest is the request struct for api ListPrivateAccessApplicationsForDynamicRoute
type ListPrivateAccessApplicationsForDynamicRouteRequest struct {
	*requests.RpcRequest
	DynamicRouteIds *[]string `position:"Query" name:"DynamicRouteIds"  type:"Repeated"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
}

// ListPrivateAccessApplicationsForDynamicRouteResponse is the response struct for api ListPrivateAccessApplicationsForDynamicRoute
type ListPrivateAccessApplicationsForDynamicRouteResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	DynamicRoutes []DynamicRoute `json:"DynamicRoutes" xml:"DynamicRoutes"`
}

// CreateListPrivateAccessApplicationsForDynamicRouteRequest creates a request to invoke ListPrivateAccessApplicationsForDynamicRoute API
func CreateListPrivateAccessApplicationsForDynamicRouteRequest() (request *ListPrivateAccessApplicationsForDynamicRouteRequest) {
	request = &ListPrivateAccessApplicationsForDynamicRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListPrivateAccessApplicationsForDynamicRoute", "", "")
	request.Method = requests.GET
	return
}

// CreateListPrivateAccessApplicationsForDynamicRouteResponse creates a response to parse from ListPrivateAccessApplicationsForDynamicRoute response
func CreateListPrivateAccessApplicationsForDynamicRouteResponse() (response *ListPrivateAccessApplicationsForDynamicRouteResponse) {
	response = &ListPrivateAccessApplicationsForDynamicRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
