package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIdpConfig invokes the csas.GetIdpConfig API synchronously
func (client *Client) GetIdpConfig(request *GetIdpConfigRequest) (response *GetIdpConfigResponse, err error) {
	response = CreateGetIdpConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetIdpConfigWithChan invokes the csas.GetIdpConfig API asynchronously
func (client *Client) GetIdpConfigWithChan(request *GetIdpConfigRequest) (<-chan *GetIdpConfigResponse, <-chan error) {
	responseChan := make(chan *GetIdpConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIdpConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIdpConfigWithCallback invokes the csas.GetIdpConfig API asynchronously
func (client *Client) GetIdpConfigWithCallback(request *GetIdpConfigRequest, callback func(response *GetIdpConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIdpConfigResponse
		var err error
		defer close(result)
		response, err = client.GetIdpConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIdpConfigRequest is the request struct for api GetIdpConfig
type GetIdpConfigRequest struct {
	*requests.RpcRequest
	Id string `position:"Query" name:"Id"`
}

// GetIdpConfigResponse is the response struct for api GetIdpConfig
type GetIdpConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetIdpConfigRequest creates a request to invoke GetIdpConfig API
func CreateGetIdpConfigRequest() (request *GetIdpConfigRequest) {
	request = &GetIdpConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetIdpConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateGetIdpConfigResponse creates a response to parse from GetIdpConfig response
func CreateGetIdpConfigResponse() (response *GetIdpConfigResponse) {
	response = &GetIdpConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
