package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDynamicRoute invokes the csas.GetDynamicRoute API synchronously
func (client *Client) GetDynamicRoute(request *GetDynamicRouteRequest) (response *GetDynamicRouteResponse, err error) {
	response = CreateGetDynamicRouteResponse()
	err = client.DoAction(request, response)
	return
}

// GetDynamicRouteWithChan invokes the csas.GetDynamicRoute API asynchronously
func (client *Client) GetDynamicRouteWithChan(request *GetDynamicRouteRequest) (<-chan *GetDynamicRouteResponse, <-chan error) {
	responseChan := make(chan *GetDynamicRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDynamicRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDynamicRouteWithCallback invokes the csas.GetDynamicRoute API asynchronously
func (client *Client) GetDynamicRouteWithCallback(request *GetDynamicRouteRequest, callback func(response *GetDynamicRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDynamicRouteResponse
		var err error
		defer close(result)
		response, err = client.GetDynamicRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDynamicRouteRequest is the request struct for api GetDynamicRoute
type GetDynamicRouteRequest struct {
	*requests.RpcRequest
	DynamicRouteId string `position:"Query" name:"DynamicRouteId"`
	SourceIp       string `position:"Query" name:"SourceIp"`
}

// GetDynamicRouteResponse is the response struct for api GetDynamicRoute
type GetDynamicRouteResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DynamicRoute DynamicRoute `json:"DynamicRoute" xml:"DynamicRoute"`
}

// CreateGetDynamicRouteRequest creates a request to invoke GetDynamicRoute API
func CreateGetDynamicRouteRequest() (request *GetDynamicRouteRequest) {
	request = &GetDynamicRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetDynamicRoute", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDynamicRouteResponse creates a response to parse from GetDynamicRoute response
func CreateGetDynamicRouteResponse() (response *GetDynamicRouteResponse) {
	response = &GetDynamicRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
