package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachPolicy2ApprovalProcess invokes the csas.DetachPolicy2ApprovalProcess API synchronously
func (client *Client) DetachPolicy2ApprovalProcess(request *DetachPolicy2ApprovalProcessRequest) (response *DetachPolicy2ApprovalProcessResponse, err error) {
	response = CreateDetachPolicy2ApprovalProcessResponse()
	err = client.DoAction(request, response)
	return
}

// DetachPolicy2ApprovalProcessWithChan invokes the csas.DetachPolicy2ApprovalProcess API asynchronously
func (client *Client) DetachPolicy2ApprovalProcessWithChan(request *DetachPolicy2ApprovalProcessRequest) (<-chan *DetachPolicy2ApprovalProcessResponse, <-chan error) {
	responseChan := make(chan *DetachPolicy2ApprovalProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachPolicy2ApprovalProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachPolicy2ApprovalProcessWithCallback invokes the csas.DetachPolicy2ApprovalProcess API asynchronously
func (client *Client) DetachPolicy2ApprovalProcessWithCallback(request *DetachPolicy2ApprovalProcessRequest, callback func(response *DetachPolicy2ApprovalProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachPolicy2ApprovalProcessResponse
		var err error
		defer close(result)
		response, err = client.DetachPolicy2ApprovalProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachPolicy2ApprovalProcessRequest is the request struct for api DetachPolicy2ApprovalProcess
type DetachPolicy2ApprovalProcessRequest struct {
	*requests.RpcRequest
	PolicyType string `position:"Body" name:"PolicyType"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	PolicyId   string `position:"Body" name:"PolicyId"`
	ProcessId  string `position:"Body" name:"ProcessId"`
}

// DetachPolicy2ApprovalProcessResponse is the response struct for api DetachPolicy2ApprovalProcess
type DetachPolicy2ApprovalProcessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachPolicy2ApprovalProcessRequest creates a request to invoke DetachPolicy2ApprovalProcess API
func CreateDetachPolicy2ApprovalProcessRequest() (request *DetachPolicy2ApprovalProcessRequest) {
	request = &DetachPolicy2ApprovalProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DetachPolicy2ApprovalProcess", "", "")
	request.Method = requests.POST
	return
}

// CreateDetachPolicy2ApprovalProcessResponse creates a response to parse from DetachPolicy2ApprovalProcess response
func CreateDetachPolicy2ApprovalProcessResponse() (response *DetachPolicy2ApprovalProcessResponse) {
	response = &DetachPolicy2ApprovalProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
