package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClientUser invokes the csas.CreateClientUser API synchronously
func (client *Client) CreateClientUser(request *CreateClientUserRequest) (response *CreateClientUserResponse, err error) {
	response = CreateCreateClientUserResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClientUserWithChan invokes the csas.CreateClientUser API asynchronously
func (client *Client) CreateClientUserWithChan(request *CreateClientUserRequest) (<-chan *CreateClientUserResponse, <-chan error) {
	responseChan := make(chan *CreateClientUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClientUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClientUserWithCallback invokes the csas.CreateClientUser API asynchronously
func (client *Client) CreateClientUserWithCallback(request *CreateClientUserRequest, callback func(response *CreateClientUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClientUserResponse
		var err error
		defer close(result)
		response, err = client.CreateClientUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClientUserRequest is the request struct for api CreateClientUser
type CreateClientUserRequest struct {
	*requests.RpcRequest
	MobileNumber string `position:"Query" name:"MobileNumber"`
	DepartmentId string `position:"Query" name:"DepartmentId"`
	Description  string `position:"Query" name:"Description"`
	IdpConfigId  string `position:"Query" name:"IdpConfigId"`
	Password     string `position:"Query" name:"Password"`
	Email        string `position:"Query" name:"Email"`
	Username     string `position:"Query" name:"Username"`
}

// CreateClientUserResponse is the response struct for api CreateClientUser
type CreateClientUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateClientUserRequest creates a request to invoke CreateClientUser API
func CreateCreateClientUserRequest() (request *CreateClientUserRequest) {
	request = &CreateClientUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "CreateClientUser", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateClientUserResponse creates a response to parse from CreateClientUser response
func CreateCreateClientUserResponse() (response *CreateClientUserResponse) {
	response = &CreateClientUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
