package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetComplianceSummary invokes the config.GetComplianceSummary API synchronously
func (client *Client) GetComplianceSummary(request *GetComplianceSummaryRequest) (response *GetComplianceSummaryResponse, err error) {
	response = CreateGetComplianceSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// GetComplianceSummaryWithChan invokes the config.GetComplianceSummary API asynchronously
func (client *Client) GetComplianceSummaryWithChan(request *GetComplianceSummaryRequest) (<-chan *GetComplianceSummaryResponse, <-chan error) {
	responseChan := make(chan *GetComplianceSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetComplianceSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetComplianceSummaryWithCallback invokes the config.GetComplianceSummary API asynchronously
func (client *Client) GetComplianceSummaryWithCallback(request *GetComplianceSummaryRequest, callback func(response *GetComplianceSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetComplianceSummaryResponse
		var err error
		defer close(result)
		response, err = client.GetComplianceSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetComplianceSummaryRequest is the request struct for api GetComplianceSummary
type GetComplianceSummaryRequest struct {
	*requests.RpcRequest
}

// GetComplianceSummaryResponse is the response struct for api GetComplianceSummary
type GetComplianceSummaryResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ComplianceSummary ComplianceSummary `json:"ComplianceSummary" xml:"ComplianceSummary"`
}

// CreateGetComplianceSummaryRequest creates a request to invoke GetComplianceSummary API
func CreateGetComplianceSummaryRequest() (request *GetComplianceSummaryRequest) {
	request = &GetComplianceSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetComplianceSummary", "", "")
	request.Method = requests.POST
	return
}

// CreateGetComplianceSummaryResponse creates a response to parse from GetComplianceSummary response
func CreateGetComplianceSummaryResponse() (response *GetComplianceSummaryResponse) {
	response = &GetComplianceSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
