package computenest

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartServiceInstance invokes the computenest.RestartServiceInstance API synchronously
func (client *Client) RestartServiceInstance(request *RestartServiceInstanceRequest) (response *RestartServiceInstanceResponse, err error) {
	response = CreateRestartServiceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RestartServiceInstanceWithChan invokes the computenest.RestartServiceInstance API asynchronously
func (client *Client) RestartServiceInstanceWithChan(request *RestartServiceInstanceRequest) (<-chan *RestartServiceInstanceResponse, <-chan error) {
	responseChan := make(chan *RestartServiceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartServiceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartServiceInstanceWithCallback invokes the computenest.RestartServiceInstance API asynchronously
func (client *Client) RestartServiceInstanceWithCallback(request *RestartServiceInstanceRequest, callback func(response *RestartServiceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartServiceInstanceResponse
		var err error
		defer close(result)
		response, err = client.RestartServiceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartServiceInstanceRequest is the request struct for api RestartServiceInstance
type RestartServiceInstanceRequest struct {
	*requests.RpcRequest
	ClientToken       string `position:"Query" name:"ClientToken"`
	ServiceInstanceId string `position:"Query" name:"ServiceInstanceId"`
}

// RestartServiceInstanceResponse is the response struct for api RestartServiceInstance
type RestartServiceInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRestartServiceInstanceRequest creates a request to invoke RestartServiceInstance API
func CreateRestartServiceInstanceRequest() (request *RestartServiceInstanceRequest) {
	request = &RestartServiceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNest", "2021-06-01", "RestartServiceInstance", "computenest", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartServiceInstanceResponse creates a response to parse from RestartServiceInstance response
func CreateRestartServiceInstanceResponse() (response *RestartServiceInstanceResponse) {
	response = &RestartServiceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
