package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteHybridMonitorSLSGroup invokes the cms.DeleteHybridMonitorSLSGroup API synchronously
func (client *Client) DeleteHybridMonitorSLSGroup(request *DeleteHybridMonitorSLSGroupRequest) (response *DeleteHybridMonitorSLSGroupResponse, err error) {
	response = CreateDeleteHybridMonitorSLSGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteHybridMonitorSLSGroupWithChan invokes the cms.DeleteHybridMonitorSLSGroup API asynchronously
func (client *Client) DeleteHybridMonitorSLSGroupWithChan(request *DeleteHybridMonitorSLSGroupRequest) (<-chan *DeleteHybridMonitorSLSGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteHybridMonitorSLSGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteHybridMonitorSLSGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteHybridMonitorSLSGroupWithCallback invokes the cms.DeleteHybridMonitorSLSGroup API asynchronously
func (client *Client) DeleteHybridMonitorSLSGroupWithCallback(request *DeleteHybridMonitorSLSGroupRequest, callback func(response *DeleteHybridMonitorSLSGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteHybridMonitorSLSGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteHybridMonitorSLSGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteHybridMonitorSLSGroupRequest is the request struct for api DeleteHybridMonitorSLSGroup
type DeleteHybridMonitorSLSGroupRequest struct {
	*requests.RpcRequest
	SLSGroupName string `position:"Query" name:"SLSGroupName"`
}

// DeleteHybridMonitorSLSGroupResponse is the response struct for api DeleteHybridMonitorSLSGroup
type DeleteHybridMonitorSLSGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDeleteHybridMonitorSLSGroupRequest creates a request to invoke DeleteHybridMonitorSLSGroup API
func CreateDeleteHybridMonitorSLSGroupRequest() (request *DeleteHybridMonitorSLSGroupRequest) {
	request = &DeleteHybridMonitorSLSGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteHybridMonitorSLSGroup", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteHybridMonitorSLSGroupResponse creates a response to parse from DeleteHybridMonitorSLSGroup response
func CreateDeleteHybridMonitorSLSGroupResponse() (response *DeleteHybridMonitorSLSGroupResponse) {
	response = &DeleteHybridMonitorSLSGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
