package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMonitorAgentProcess invokes the cms.CreateMonitorAgentProcess API synchronously
func (client *Client) CreateMonitorAgentProcess(request *CreateMonitorAgentProcessRequest) (response *CreateMonitorAgentProcessResponse, err error) {
	response = CreateCreateMonitorAgentProcessResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMonitorAgentProcessWithChan invokes the cms.CreateMonitorAgentProcess API asynchronously
func (client *Client) CreateMonitorAgentProcessWithChan(request *CreateMonitorAgentProcessRequest) (<-chan *CreateMonitorAgentProcessResponse, <-chan error) {
	responseChan := make(chan *CreateMonitorAgentProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMonitorAgentProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMonitorAgentProcessWithCallback invokes the cms.CreateMonitorAgentProcess API asynchronously
func (client *Client) CreateMonitorAgentProcessWithCallback(request *CreateMonitorAgentProcessRequest, callback func(response *CreateMonitorAgentProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMonitorAgentProcessResponse
		var err error
		defer close(result)
		response, err = client.CreateMonitorAgentProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMonitorAgentProcessRequest is the request struct for api CreateMonitorAgentProcess
type CreateMonitorAgentProcessRequest struct {
	*requests.RpcRequest
	ProcessName string `position:"Query" name:"ProcessName"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	ProcessUser string `position:"Query" name:"ProcessUser"`
}

// CreateMonitorAgentProcessResponse is the response struct for api CreateMonitorAgentProcess
type CreateMonitorAgentProcessResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Id        int64  `json:"Id" xml:"Id"`
}

// CreateCreateMonitorAgentProcessRequest creates a request to invoke CreateMonitorAgentProcess API
func CreateCreateMonitorAgentProcessRequest() (request *CreateMonitorAgentProcessRequest) {
	request = &CreateMonitorAgentProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateMonitorAgentProcess", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMonitorAgentProcessResponse creates a response to parse from CreateMonitorAgentProcess response
func CreateCreateMonitorAgentProcessResponse() (response *CreateMonitorAgentProcessResponse) {
	response = &CreateMonitorAgentProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
