package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateHybridMonitorNamespace invokes the cms.CreateHybridMonitorNamespace API synchronously
func (client *Client) CreateHybridMonitorNamespace(request *CreateHybridMonitorNamespaceRequest) (response *CreateHybridMonitorNamespaceResponse, err error) {
	response = CreateCreateHybridMonitorNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateHybridMonitorNamespaceWithChan invokes the cms.CreateHybridMonitorNamespace API asynchronously
func (client *Client) CreateHybridMonitorNamespaceWithChan(request *CreateHybridMonitorNamespaceRequest) (<-chan *CreateHybridMonitorNamespaceResponse, <-chan error) {
	responseChan := make(chan *CreateHybridMonitorNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateHybridMonitorNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateHybridMonitorNamespaceWithCallback invokes the cms.CreateHybridMonitorNamespace API asynchronously
func (client *Client) CreateHybridMonitorNamespaceWithCallback(request *CreateHybridMonitorNamespaceRequest, callback func(response *CreateHybridMonitorNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateHybridMonitorNamespaceResponse
		var err error
		defer close(result)
		response, err = client.CreateHybridMonitorNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateHybridMonitorNamespaceRequest is the request struct for api CreateHybridMonitorNamespace
type CreateHybridMonitorNamespaceRequest struct {
	*requests.RpcRequest
	Description string `position:"Query" name:"Description"`
	Spec        string `position:"Query" name:"Spec"`
	Namespace   string `position:"Query" name:"Namespace"`
}

// CreateHybridMonitorNamespaceResponse is the response struct for api CreateHybridMonitorNamespace
type CreateHybridMonitorNamespaceResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateCreateHybridMonitorNamespaceRequest creates a request to invoke CreateHybridMonitorNamespace API
func CreateCreateHybridMonitorNamespaceRequest() (request *CreateHybridMonitorNamespaceRequest) {
	request = &CreateHybridMonitorNamespaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateHybridMonitorNamespace", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateHybridMonitorNamespaceResponse creates a response to parse from CreateHybridMonitorNamespace response
func CreateCreateHybridMonitorNamespaceResponse() (response *CreateHybridMonitorNamespaceResponse) {
	response = &CreateHybridMonitorNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
