package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchCreateInstantSiteMonitor invokes the cms.BatchCreateInstantSiteMonitor API synchronously
func (client *Client) BatchCreateInstantSiteMonitor(request *BatchCreateInstantSiteMonitorRequest) (response *BatchCreateInstantSiteMonitorResponse, err error) {
	response = CreateBatchCreateInstantSiteMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// BatchCreateInstantSiteMonitorWithChan invokes the cms.BatchCreateInstantSiteMonitor API asynchronously
func (client *Client) BatchCreateInstantSiteMonitorWithChan(request *BatchCreateInstantSiteMonitorRequest) (<-chan *BatchCreateInstantSiteMonitorResponse, <-chan error) {
	responseChan := make(chan *BatchCreateInstantSiteMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchCreateInstantSiteMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchCreateInstantSiteMonitorWithCallback invokes the cms.BatchCreateInstantSiteMonitor API asynchronously
func (client *Client) BatchCreateInstantSiteMonitorWithCallback(request *BatchCreateInstantSiteMonitorRequest, callback func(response *BatchCreateInstantSiteMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchCreateInstantSiteMonitorResponse
		var err error
		defer close(result)
		response, err = client.BatchCreateInstantSiteMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchCreateInstantSiteMonitorRequest is the request struct for api BatchCreateInstantSiteMonitor
type BatchCreateInstantSiteMonitorRequest struct {
	*requests.RpcRequest
	TaskList *[]BatchCreateInstantSiteMonitorTaskList `position:"Query" name:"TaskList"  type:"Repeated"`
}

// BatchCreateInstantSiteMonitorTaskList is a repeated param struct in BatchCreateInstantSiteMonitorRequest
type BatchCreateInstantSiteMonitorTaskList struct {
	OptionsJson string `name:"OptionsJson"`
	Address     string `name:"Address"`
	TaskType    string `name:"TaskType"`
	TaskName    string `name:"TaskName"`
	IspCities   string `name:"IspCities"`
}

// BatchCreateInstantSiteMonitorResponse is the response struct for api BatchCreateInstantSiteMonitor
type BatchCreateInstantSiteMonitorResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Message   string     `json:"Message" xml:"Message"`
	Success   bool       `json:"Success" xml:"Success"`
	Code      string     `json:"Code" xml:"Code"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateBatchCreateInstantSiteMonitorRequest creates a request to invoke BatchCreateInstantSiteMonitor API
func CreateBatchCreateInstantSiteMonitorRequest() (request *BatchCreateInstantSiteMonitorRequest) {
	request = &BatchCreateInstantSiteMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "BatchCreateInstantSiteMonitor", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchCreateInstantSiteMonitorResponse creates a response to parse from BatchCreateInstantSiteMonitor response
func CreateBatchCreateInstantSiteMonitorResponse() (response *BatchCreateInstantSiteMonitorResponse) {
	response = &BatchCreateInstantSiteMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
