package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopMarketingList invokes the cloudwf.ShopMarketingList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopmarketinglist.html
func (client *Client) ShopMarketingList(request *ShopMarketingListRequest) (response *ShopMarketingListResponse, err error) {
	response = CreateShopMarketingListResponse()
	err = client.DoAction(request, response)
	return
}

// ShopMarketingListWithChan invokes the cloudwf.ShopMarketingList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopmarketinglist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopMarketingListWithChan(request *ShopMarketingListRequest) (<-chan *ShopMarketingListResponse, <-chan error) {
	responseChan := make(chan *ShopMarketingListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopMarketingList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopMarketingListWithCallback invokes the cloudwf.ShopMarketingList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopmarketinglist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopMarketingListWithCallback(request *ShopMarketingListRequest, callback func(response *ShopMarketingListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopMarketingListResponse
		var err error
		defer close(result)
		response, err = client.ShopMarketingList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopMarketingListRequest is the request struct for api ShopMarketingList
type ShopMarketingListRequest struct {
	*requests.RpcRequest
	Name string           `position:"Query" name:"Name"`
	Page requests.Integer `position:"Query" name:"Page"`
	Per  requests.Integer `position:"Query" name:"Per"`
	Sid  requests.Integer `position:"Query" name:"Sid"`
}

// ShopMarketingListResponse is the response struct for api ShopMarketingList
type ShopMarketingListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopMarketingListRequest creates a request to invoke ShopMarketingList API
func CreateShopMarketingListRequest() (request *ShopMarketingListRequest) {
	request = &ShopMarketingListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopMarketingList", "cloudwf", "openAPI")
	return
}

// CreateShopMarketingListResponse creates a response to parse from ShopMarketingList response
func CreateShopMarketingListResponse() (response *ShopMarketingListResponse) {
	response = &ShopMarketingListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
