package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopInfo invokes the cloudwf.ShopInfo API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopinfo.html
func (client *Client) ShopInfo(request *ShopInfoRequest) (response *ShopInfoResponse, err error) {
	response = CreateShopInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ShopInfoWithChan invokes the cloudwf.ShopInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopInfoWithChan(request *ShopInfoRequest) (<-chan *ShopInfoResponse, <-chan error) {
	responseChan := make(chan *ShopInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopInfoWithCallback invokes the cloudwf.ShopInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopInfoWithCallback(request *ShopInfoRequest, callback func(response *ShopInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopInfoResponse
		var err error
		defer close(result)
		response, err = client.ShopInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopInfoRequest is the request struct for api ShopInfo
type ShopInfoRequest struct {
	*requests.RpcRequest
	Sid requests.Integer `position:"Query" name:"Sid"`
}

// ShopInfoResponse is the response struct for api ShopInfo
type ShopInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopInfoRequest creates a request to invoke ShopInfo API
func CreateShopInfoRequest() (request *ShopInfoRequest) {
	request = &ShopInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopInfo", "cloudwf", "openAPI")
	return
}

// CreateShopInfoResponse creates a response to parse from ShopInfo response
func CreateShopInfoResponse() (response *ShopInfoResponse) {
	response = &ShopInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
