package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveApMapInfo invokes the cloudwf.SaveApMapInfo API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapmapinfo.html
func (client *Client) SaveApMapInfo(request *SaveApMapInfoRequest) (response *SaveApMapInfoResponse, err error) {
	response = CreateSaveApMapInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SaveApMapInfoWithChan invokes the cloudwf.SaveApMapInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapmapinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApMapInfoWithChan(request *SaveApMapInfoRequest) (<-chan *SaveApMapInfoResponse, <-chan error) {
	responseChan := make(chan *SaveApMapInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveApMapInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveApMapInfoWithCallback invokes the cloudwf.SaveApMapInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveapmapinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveApMapInfoWithCallback(request *SaveApMapInfoRequest, callback func(response *SaveApMapInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveApMapInfoResponse
		var err error
		defer close(result)
		response, err = client.SaveApMapInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveApMapInfoRequest is the request struct for api SaveApMapInfo
type SaveApMapInfoRequest struct {
	*requests.RpcRequest
	JsonData string `position:"Query" name:"JsonData"`
}

// SaveApMapInfoResponse is the response struct for api SaveApMapInfo
type SaveApMapInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveApMapInfoRequest creates a request to invoke SaveApMapInfo API
func CreateSaveApMapInfoRequest() (request *SaveApMapInfoRequest) {
	request = &SaveApMapInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveApMapInfo", "cloudwf", "openAPI")
	return
}

// CreateSaveApMapInfoResponse creates a response to parse from SaveApMapInfo response
func CreateSaveApMapInfoResponse() (response *SaveApMapInfoResponse) {
	response = &SaveApMapInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
