package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyControlPolicyPosition invokes the cloudfw.ModifyControlPolicyPosition API synchronously
func (client *Client) ModifyControlPolicyPosition(request *ModifyControlPolicyPositionRequest) (response *ModifyControlPolicyPositionResponse, err error) {
	response = CreateModifyControlPolicyPositionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyControlPolicyPositionWithChan invokes the cloudfw.ModifyControlPolicyPosition API asynchronously
func (client *Client) ModifyControlPolicyPositionWithChan(request *ModifyControlPolicyPositionRequest) (<-chan *ModifyControlPolicyPositionResponse, <-chan error) {
	responseChan := make(chan *ModifyControlPolicyPositionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyControlPolicyPosition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyControlPolicyPositionWithCallback invokes the cloudfw.ModifyControlPolicyPosition API asynchronously
func (client *Client) ModifyControlPolicyPositionWithCallback(request *ModifyControlPolicyPositionRequest, callback func(response *ModifyControlPolicyPositionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyControlPolicyPositionResponse
		var err error
		defer close(result)
		response, err = client.ModifyControlPolicyPosition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyControlPolicyPositionRequest is the request struct for api ModifyControlPolicyPosition
type ModifyControlPolicyPositionRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	NewOrder  string `position:"Query" name:"NewOrder"`
	Lang      string `position:"Query" name:"Lang"`
	OldOrder  string `position:"Query" name:"OldOrder"`
	Direction string `position:"Query" name:"Direction"`
}

// ModifyControlPolicyPositionResponse is the response struct for api ModifyControlPolicyPosition
type ModifyControlPolicyPositionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyControlPolicyPositionRequest creates a request to invoke ModifyControlPolicyPosition API
func CreateModifyControlPolicyPositionRequest() (request *ModifyControlPolicyPositionRequest) {
	request = &ModifyControlPolicyPositionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyControlPolicyPosition", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyControlPolicyPositionResponse creates a response to parse from ModifyControlPolicyPosition response
func CreateModifyControlPolicyPositionResponse() (response *ModifyControlPolicyPositionResponse) {
	response = &ModifyControlPolicyPositionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
