package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcFirewallCenList invokes the cloudfw.DescribeVpcFirewallCenList API synchronously
func (client *Client) DescribeVpcFirewallCenList(request *DescribeVpcFirewallCenListRequest) (response *DescribeVpcFirewallCenListResponse, err error) {
	response = CreateDescribeVpcFirewallCenListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcFirewallCenListWithChan invokes the cloudfw.DescribeVpcFirewallCenList API asynchronously
func (client *Client) DescribeVpcFirewallCenListWithChan(request *DescribeVpcFirewallCenListRequest) (<-chan *DescribeVpcFirewallCenListResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcFirewallCenListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcFirewallCenList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcFirewallCenListWithCallback invokes the cloudfw.DescribeVpcFirewallCenList API asynchronously
func (client *Client) DescribeVpcFirewallCenListWithCallback(request *DescribeVpcFirewallCenListRequest, callback func(response *DescribeVpcFirewallCenListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcFirewallCenListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcFirewallCenList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcFirewallCenListRequest is the request struct for api DescribeVpcFirewallCenList
type DescribeVpcFirewallCenListRequest struct {
	*requests.RpcRequest
	CenId                string `position:"Query" name:"CenId"`
	NetworkInstanceId    string `position:"Query" name:"NetworkInstanceId"`
	VpcFirewallName      string `position:"Query" name:"VpcFirewallName"`
	SourceIp             string `position:"Query" name:"SourceIp"`
	PageSize             string `position:"Query" name:"PageSize"`
	Lang                 string `position:"Query" name:"Lang"`
	VpcFirewallId        string `position:"Query" name:"VpcFirewallId"`
	RouteMode            string `position:"Query" name:"RouteMode"`
	CurrentPage          string `position:"Query" name:"CurrentPage"`
	FirewallSwitchStatus string `position:"Query" name:"FirewallSwitchStatus"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	RegionNo             string `position:"Query" name:"RegionNo"`
	MemberUid            string `position:"Query" name:"MemberUid"`
	TransitRouterType    string `position:"Query" name:"TransitRouterType"`
}

// DescribeVpcFirewallCenListResponse is the response struct for api DescribeVpcFirewallCenList
type DescribeVpcFirewallCenListResponse struct {
	*responses.BaseResponse
	TotalCount   int                                `json:"TotalCount" xml:"TotalCount"`
	RequestId    string                             `json:"RequestId" xml:"RequestId"`
	VpcFirewalls []DataInDescribeVpcFirewallCenList `json:"VpcFirewalls" xml:"VpcFirewalls"`
}

// CreateDescribeVpcFirewallCenListRequest creates a request to invoke DescribeVpcFirewallCenList API
func CreateDescribeVpcFirewallCenListRequest() (request *DescribeVpcFirewallCenListRequest) {
	request = &DescribeVpcFirewallCenListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeVpcFirewallCenList", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcFirewallCenListResponse creates a response to parse from DescribeVpcFirewallCenList response
func CreateDescribeVpcFirewallCenListResponse() (response *DescribeVpcFirewallCenListResponse) {
	response = &DescribeVpcFirewallCenListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
