package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpcFirewallConfigure invokes the cloudfw.DeleteVpcFirewallConfigure API synchronously
func (client *Client) DeleteVpcFirewallConfigure(request *DeleteVpcFirewallConfigureRequest) (response *DeleteVpcFirewallConfigureResponse, err error) {
	response = CreateDeleteVpcFirewallConfigureResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpcFirewallConfigureWithChan invokes the cloudfw.DeleteVpcFirewallConfigure API asynchronously
func (client *Client) DeleteVpcFirewallConfigureWithChan(request *DeleteVpcFirewallConfigureRequest) (<-chan *DeleteVpcFirewallConfigureResponse, <-chan error) {
	responseChan := make(chan *DeleteVpcFirewallConfigureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpcFirewallConfigure(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpcFirewallConfigureWithCallback invokes the cloudfw.DeleteVpcFirewallConfigure API asynchronously
func (client *Client) DeleteVpcFirewallConfigureWithCallback(request *DeleteVpcFirewallConfigureRequest, callback func(response *DeleteVpcFirewallConfigureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpcFirewallConfigureResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpcFirewallConfigure(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpcFirewallConfigureRequest is the request struct for api DeleteVpcFirewallConfigure
type DeleteVpcFirewallConfigureRequest struct {
	*requests.RpcRequest
	SourceIp          string    `position:"Query" name:"SourceIp"`
	MemberUid         string    `position:"Query" name:"MemberUid"`
	VpcFirewallIdList *[]string `position:"Query" name:"VpcFirewallIdList"  type:"Repeated"`
	Lang              string    `position:"Query" name:"Lang"`
}

// DeleteVpcFirewallConfigureResponse is the response struct for api DeleteVpcFirewallConfigure
type DeleteVpcFirewallConfigureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVpcFirewallConfigureRequest creates a request to invoke DeleteVpcFirewallConfigure API
func CreateDeleteVpcFirewallConfigureRequest() (request *DeleteVpcFirewallConfigureRequest) {
	request = &DeleteVpcFirewallConfigureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DeleteVpcFirewallConfigure", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpcFirewallConfigureResponse creates a response to parse from DeleteVpcFirewallConfigure response
func CreateDeleteVpcFirewallConfigureResponse() (response *DeleteVpcFirewallConfigureResponse) {
	response = &DeleteVpcFirewallConfigureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
