package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrFirewallV2RoutePolicy invokes the cloudfw.CreateTrFirewallV2RoutePolicy API synchronously
func (client *Client) CreateTrFirewallV2RoutePolicy(request *CreateTrFirewallV2RoutePolicyRequest) (response *CreateTrFirewallV2RoutePolicyResponse, err error) {
	response = CreateCreateTrFirewallV2RoutePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrFirewallV2RoutePolicyWithChan invokes the cloudfw.CreateTrFirewallV2RoutePolicy API asynchronously
func (client *Client) CreateTrFirewallV2RoutePolicyWithChan(request *CreateTrFirewallV2RoutePolicyRequest) (<-chan *CreateTrFirewallV2RoutePolicyResponse, <-chan error) {
	responseChan := make(chan *CreateTrFirewallV2RoutePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrFirewallV2RoutePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrFirewallV2RoutePolicyWithCallback invokes the cloudfw.CreateTrFirewallV2RoutePolicy API asynchronously
func (client *Client) CreateTrFirewallV2RoutePolicyWithCallback(request *CreateTrFirewallV2RoutePolicyRequest, callback func(response *CreateTrFirewallV2RoutePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrFirewallV2RoutePolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateTrFirewallV2RoutePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrFirewallV2RoutePolicyRequest is the request struct for api CreateTrFirewallV2RoutePolicy
type CreateTrFirewallV2RoutePolicyRequest struct {
	*requests.RpcRequest
	FirewallId        string                                            `position:"Query" name:"FirewallId"`
	SourceIp          string                                            `position:"Query" name:"SourceIp"`
	SrcCandidateList  *[]CreateTrFirewallV2RoutePolicySrcCandidateList  `position:"Query" name:"SrcCandidateList"  type:"Json"`
	Lang              string                                            `position:"Query" name:"Lang"`
	DestCandidateList *[]CreateTrFirewallV2RoutePolicyDestCandidateList `position:"Query" name:"DestCandidateList"  type:"Json"`
	PolicyType        string                                            `position:"Query" name:"PolicyType"`
	PolicyName        string                                            `position:"Query" name:"PolicyName"`
	PolicyDescription string                                            `position:"Query" name:"PolicyDescription"`
}

// CreateTrFirewallV2RoutePolicySrcCandidateList is a repeated param struct in CreateTrFirewallV2RoutePolicyRequest
type CreateTrFirewallV2RoutePolicySrcCandidateList struct {
	CandidateType string `name:"CandidateType"`
	CandidateId   string `name:"CandidateId"`
}

// CreateTrFirewallV2RoutePolicyDestCandidateList is a repeated param struct in CreateTrFirewallV2RoutePolicyRequest
type CreateTrFirewallV2RoutePolicyDestCandidateList struct {
	CandidateType string `name:"CandidateType"`
	CandidateId   string `name:"CandidateId"`
}

// CreateTrFirewallV2RoutePolicyResponse is the response struct for api CreateTrFirewallV2RoutePolicy
type CreateTrFirewallV2RoutePolicyResponse struct {
	*responses.BaseResponse
	TrFirewallRoutePolicyId string `json:"TrFirewallRoutePolicyId" xml:"TrFirewallRoutePolicyId"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTrFirewallV2RoutePolicyRequest creates a request to invoke CreateTrFirewallV2RoutePolicy API
func CreateCreateTrFirewallV2RoutePolicyRequest() (request *CreateTrFirewallV2RoutePolicyRequest) {
	request = &CreateTrFirewallV2RoutePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "CreateTrFirewallV2RoutePolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTrFirewallV2RoutePolicyResponse creates a response to parse from CreateTrFirewallV2RoutePolicy response
func CreateCreateTrFirewallV2RoutePolicyResponse() (response *CreateTrFirewallV2RoutePolicyResponse) {
	response = &CreateTrFirewallV2RoutePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
