package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEslDevices invokes the cloudesl.GetEslDevices API synchronously
func (client *Client) GetEslDevices(request *GetEslDevicesRequest) (response *GetEslDevicesResponse, err error) {
	response = CreateGetEslDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// GetEslDevicesWithChan invokes the cloudesl.GetEslDevices API asynchronously
func (client *Client) GetEslDevicesWithChan(request *GetEslDevicesRequest) (<-chan *GetEslDevicesResponse, <-chan error) {
	responseChan := make(chan *GetEslDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEslDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEslDevicesWithCallback invokes the cloudesl.GetEslDevices API asynchronously
func (client *Client) GetEslDevicesWithCallback(request *GetEslDevicesRequest, callback func(response *GetEslDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEslDevicesResponse
		var err error
		defer close(result)
		response, err = client.GetEslDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEslDevicesRequest is the request struct for api GetEslDevices
type GetEslDevicesRequest struct {
	*requests.RpcRequest
	StoreId    string `position:"Body" name:"StoreId"`
	EslBarCode string `position:"Body" name:"EslBarCode"`
}

// GetEslDevicesResponse is the response struct for api GetEslDevices
type GetEslDevicesResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	EslBarCode     string `json:"EslBarCode" xml:"EslBarCode"`
	Type           string `json:"Type" xml:"Type"`
}

// CreateGetEslDevicesRequest creates a request to invoke GetEslDevices API
func CreateGetEslDevicesRequest() (request *GetEslDevicesRequest) {
	request = &GetEslDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "GetEslDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateGetEslDevicesResponse creates a response to parse from GetEslDevices response
func CreateGetEslDevicesResponse() (response *GetEslDevicesResponse) {
	response = &GetEslDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
