package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCorpIdentify invokes the cloudcallcenter.GetCorpIdentify API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcorpidentify.html
func (client *Client) GetCorpIdentify(request *GetCorpIdentifyRequest) (response *GetCorpIdentifyResponse, err error) {
	response = CreateGetCorpIdentifyResponse()
	err = client.DoAction(request, response)
	return
}

// GetCorpIdentifyWithChan invokes the cloudcallcenter.GetCorpIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcorpidentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCorpIdentifyWithChan(request *GetCorpIdentifyRequest) (<-chan *GetCorpIdentifyResponse, <-chan error) {
	responseChan := make(chan *GetCorpIdentifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCorpIdentify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCorpIdentifyWithCallback invokes the cloudcallcenter.GetCorpIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcorpidentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCorpIdentifyWithCallback(request *GetCorpIdentifyRequest, callback func(response *GetCorpIdentifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCorpIdentifyResponse
		var err error
		defer close(result)
		response, err = client.GetCorpIdentify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCorpIdentifyRequest is the request struct for api GetCorpIdentify
type GetCorpIdentifyRequest struct {
	*requests.RpcRequest
	TaobaoUid requests.Integer `position:"Query" name:"TaobaoUid"`
	RamId     requests.Integer `position:"Query" name:"RamId"`
}

// GetCorpIdentifyResponse is the response struct for api GetCorpIdentify
type GetCorpIdentifyResponse struct {
	*responses.BaseResponse
	RequestId      string                          `json:"RequestId" xml:"RequestId"`
	Success        bool                            `json:"Success" xml:"Success"`
	Code           string                          `json:"Code" xml:"Code"`
	Message        string                          `json:"Message" xml:"Message"`
	HttpStatusCode int                             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	CorpIdentifies CorpIdentifiesInGetCorpIdentify `json:"CorpIdentifies" xml:"CorpIdentifies"`
}

// CreateGetCorpIdentifyRequest creates a request to invoke GetCorpIdentify API
func CreateGetCorpIdentifyRequest() (request *GetCorpIdentifyRequest) {
	request = &GetCorpIdentifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetCorpIdentify", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCorpIdentifyResponse creates a response to parse from GetCorpIdentify response
func CreateGetCorpIdentifyResponse() (response *GetCorpIdentifyResponse) {
	response = &GetCorpIdentifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
