package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigItemForFlat invokes the cloudcallcenter.GetConfigItemForFlat API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconfigitemforflat.html
func (client *Client) GetConfigItemForFlat(request *GetConfigItemForFlatRequest) (response *GetConfigItemForFlatResponse, err error) {
	response = CreateGetConfigItemForFlatResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigItemForFlatWithChan invokes the cloudcallcenter.GetConfigItemForFlat API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconfigitemforflat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetConfigItemForFlatWithChan(request *GetConfigItemForFlatRequest) (<-chan *GetConfigItemForFlatResponse, <-chan error) {
	responseChan := make(chan *GetConfigItemForFlatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigItemForFlat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigItemForFlatWithCallback invokes the cloudcallcenter.GetConfigItemForFlat API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconfigitemforflat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetConfigItemForFlatWithCallback(request *GetConfigItemForFlatRequest, callback func(response *GetConfigItemForFlatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigItemForFlatResponse
		var err error
		defer close(result)
		response, err = client.GetConfigItemForFlat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigItemForFlatRequest is the request struct for api GetConfigItemForFlat
type GetConfigItemForFlatRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Query" name:"InstanceId"`
	Name          string `position:"Query" name:"Name"`
	DimensionName string `position:"Query" name:"DimensionName"`
	Dimension     string `position:"Query" name:"Dimension"`
}

// GetConfigItemForFlatResponse is the response struct for api GetConfigItemForFlat
type GetConfigItemForFlatResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Code           string     `json:"Code" xml:"Code"`
	Message        string     `json:"Message" xml:"Message"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ConfigItem     ConfigItem `json:"ConfigItem" xml:"ConfigItem"`
}

// CreateGetConfigItemForFlatRequest creates a request to invoke GetConfigItemForFlat API
func CreateGetConfigItemForFlatRequest() (request *GetConfigItemForFlatRequest) {
	request = &GetConfigItemForFlatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetConfigItemForFlat", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConfigItemForFlatResponse creates a response to parse from GetConfigItemForFlat response
func CreateGetConfigItemForFlatResponse() (response *GetConfigItemForFlatResponse) {
	response = &GetConfigItemForFlatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
