package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVnConversation invokes the cloudcallcenter.DescribeVnConversation API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnconversation.html
func (client *Client) DescribeVnConversation(request *DescribeVnConversationRequest) (response *DescribeVnConversationResponse, err error) {
	response = CreateDescribeVnConversationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVnConversationWithChan invokes the cloudcallcenter.DescribeVnConversation API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnconversation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnConversationWithChan(request *DescribeVnConversationRequest) (<-chan *DescribeVnConversationResponse, <-chan error) {
	responseChan := make(chan *DescribeVnConversationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVnConversation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVnConversationWithCallback invokes the cloudcallcenter.DescribeVnConversation API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnconversation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnConversationWithCallback(request *DescribeVnConversationRequest, callback func(response *DescribeVnConversationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVnConversationResponse
		var err error
		defer close(result)
		response, err = client.DescribeVnConversation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVnConversationRequest is the request struct for api DescribeVnConversation
type DescribeVnConversationRequest struct {
	*requests.RpcRequest
	ConversationId string `position:"Query" name:"ConversationId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// DescribeVnConversationResponse is the response struct for api DescribeVnConversation
type DescribeVnConversationResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	CallingNumber        string `json:"CallingNumber" xml:"CallingNumber"`
	BeginTime            int64  `json:"BeginTime" xml:"BeginTime"`
	EndTime              int64  `json:"EndTime" xml:"EndTime"`
	TransferredToAgent   bool   `json:"TransferredToAgent" xml:"TransferredToAgent"`
	SkillGroupId         string `json:"SkillGroupId" xml:"SkillGroupId"`
	UserUtteranceCount   int    `json:"UserUtteranceCount" xml:"UserUtteranceCount"`
	EffectiveAnswerCount int    `json:"EffectiveAnswerCount" xml:"EffectiveAnswerCount"`
	ConversationId       string `json:"ConversationId" xml:"ConversationId"`
}

// CreateDescribeVnConversationRequest creates a request to invoke DescribeVnConversation API
func CreateDescribeVnConversationRequest() (request *DescribeVnConversationRequest) {
	request = &DescribeVnConversationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DescribeVnConversation", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVnConversationResponse creates a response to parse from DescribeVnConversation response
func CreateDescribeVnConversationResponse() (response *DescribeVnConversationResponse) {
	response = &DescribeVnConversationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
