package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrModifySystemSpecification invokes the cloudcallcenter.CreateOrModifySystemSpecification API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createormodifysystemspecification.html
func (client *Client) CreateOrModifySystemSpecification(request *CreateOrModifySystemSpecificationRequest) (response *CreateOrModifySystemSpecificationResponse, err error) {
	response = CreateCreateOrModifySystemSpecificationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrModifySystemSpecificationWithChan invokes the cloudcallcenter.CreateOrModifySystemSpecification API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createormodifysystemspecification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateOrModifySystemSpecificationWithChan(request *CreateOrModifySystemSpecificationRequest) (<-chan *CreateOrModifySystemSpecificationResponse, <-chan error) {
	responseChan := make(chan *CreateOrModifySystemSpecificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrModifySystemSpecification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrModifySystemSpecificationWithCallback invokes the cloudcallcenter.CreateOrModifySystemSpecification API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createormodifysystemspecification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateOrModifySystemSpecificationWithCallback(request *CreateOrModifySystemSpecificationRequest, callback func(response *CreateOrModifySystemSpecificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrModifySystemSpecificationResponse
		var err error
		defer close(result)
		response, err = client.CreateOrModifySystemSpecification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrModifySystemSpecificationRequest is the request struct for api CreateOrModifySystemSpecification
type CreateOrModifySystemSpecificationRequest struct {
	*requests.RpcRequest
	MaxContactFlows requests.Integer `position:"Query" name:"MaxContactFlows"`
	MaxRoles        requests.Integer `position:"Query" name:"MaxRoles"`
	StorageMaxDays  requests.Integer `position:"Query" name:"StorageMaxDays"`
	MaxInstances    requests.Integer `position:"Query" name:"MaxInstances"`
	MaxAgents       requests.Integer `position:"Query" name:"MaxAgents"`
	MaxOnlineAgents requests.Integer `position:"Query" name:"MaxOnlineAgents"`
	MaxSkillGroups  requests.Integer `position:"Query" name:"MaxSkillGroups"`
	StorageMaxSize  requests.Integer `position:"Query" name:"StorageMaxSize"`
	MaxPhoneNumbers requests.Integer `position:"Query" name:"MaxPhoneNumbers"`
}

// CreateOrModifySystemSpecificationResponse is the response struct for api CreateOrModifySystemSpecification
type CreateOrModifySystemSpecificationResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Success             bool                `json:"Success" xml:"Success"`
	Code                string              `json:"Code" xml:"Code"`
	Message             string              `json:"Message" xml:"Message"`
	HttpStatusCode      int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	SystemSpecification SystemSpecification `json:"SystemSpecification" xml:"SystemSpecification"`
}

// CreateCreateOrModifySystemSpecificationRequest creates a request to invoke CreateOrModifySystemSpecification API
func CreateCreateOrModifySystemSpecificationRequest() (request *CreateOrModifySystemSpecificationRequest) {
	request = &CreateOrModifySystemSpecificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateOrModifySystemSpecification", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateOrModifySystemSpecificationResponse creates a response to parse from CreateOrModifySystemSpecification response
func CreateCreateOrModifySystemSpecificationResponse() (response *CreateOrModifySystemSpecificationResponse) {
	response = &CreateOrModifySystemSpecificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
