package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCorpNumber invokes the cloudcallcenter.CreateCorpNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createcorpnumber.html
func (client *Client) CreateCorpNumber(request *CreateCorpNumberRequest) (response *CreateCorpNumberResponse, err error) {
	response = CreateCreateCorpNumberResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCorpNumberWithChan invokes the cloudcallcenter.CreateCorpNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createcorpnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCorpNumberWithChan(request *CreateCorpNumberRequest) (<-chan *CreateCorpNumberResponse, <-chan error) {
	responseChan := make(chan *CreateCorpNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCorpNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCorpNumberWithCallback invokes the cloudcallcenter.CreateCorpNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createcorpnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCorpNumberWithCallback(request *CreateCorpNumberRequest, callback func(response *CreateCorpNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCorpNumberResponse
		var err error
		defer close(result)
		response, err = client.CreateCorpNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCorpNumberRequest is the request struct for api CreateCorpNumber
type CreateCorpNumberRequest struct {
	*requests.RpcRequest
	RealNameInsId      requests.Integer `position:"Query" name:"RealNameInsId"`
	RegionNameProvince string           `position:"Query" name:"regionNameProvince"`
	TaobaoUid          requests.Integer `position:"Query" name:"TaobaoUid"`
	RamId              requests.Integer `position:"Query" name:"RamId"`
	MonthlyPrice       string           `position:"Query" name:"monthlyPrice"`
	Number             string           `position:"Query" name:"Number"`
	CorpName           string           `position:"Query" name:"corpName"`
	RegionNameCity     string           `position:"Query" name:"regionNameCity"`
}

// CreateCorpNumberResponse is the response struct for api CreateCorpNumber
type CreateCorpNumberResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateCreateCorpNumberRequest creates a request to invoke CreateCorpNumber API
func CreateCreateCorpNumberRequest() (request *CreateCorpNumberRequest) {
	request = &CreateCorpNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateCorpNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCorpNumberResponse creates a response to parse from CreateCorpNumber response
func CreateCreateCorpNumberResponse() (response *CreateCorpNumberResponse) {
	response = &CreateCorpNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
