package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VehicleQuery invokes the cloudauth.VehicleQuery API synchronously
func (client *Client) VehicleQuery(request *VehicleQueryRequest) (response *VehicleQueryResponse, err error) {
	response = CreateVehicleQueryResponse()
	err = client.DoAction(request, response)
	return
}

// VehicleQueryWithChan invokes the cloudauth.VehicleQuery API asynchronously
func (client *Client) VehicleQueryWithChan(request *VehicleQueryRequest) (<-chan *VehicleQueryResponse, <-chan error) {
	responseChan := make(chan *VehicleQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VehicleQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VehicleQueryWithCallback invokes the cloudauth.VehicleQuery API asynchronously
func (client *Client) VehicleQueryWithCallback(request *VehicleQueryRequest, callback func(response *VehicleQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VehicleQueryResponse
		var err error
		defer close(result)
		response, err = client.VehicleQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VehicleQueryRequest is the request struct for api VehicleQuery
type VehicleQueryRequest struct {
	*requests.RpcRequest
	VehicleType string `position:"Query" name:"VehicleType"`
	ParamType   string `position:"Query" name:"ParamType"`
	VehicleNum  string `position:"Query" name:"VehicleNum"`
}

// VehicleQueryResponse is the response struct for api VehicleQuery
type VehicleQueryResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Message      string       `json:"Message" xml:"Message"`
	Code         string       `json:"Code" xml:"Code"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateVehicleQueryRequest creates a request to invoke VehicleQuery API
func CreateVehicleQueryRequest() (request *VehicleQueryRequest) {
	request = &VehicleQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "VehicleQuery", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVehicleQueryResponse creates a response to parse from VehicleQuery response
func CreateVehicleQueryResponse() (response *VehicleQueryResponse) {
	response = &VehicleQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
