package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveVpcAccessAndAbolishApis invokes the cloudapi.RemoveVpcAccessAndAbolishApis API synchronously
func (client *Client) RemoveVpcAccessAndAbolishApis(request *RemoveVpcAccessAndAbolishApisRequest) (response *RemoveVpcAccessAndAbolishApisResponse, err error) {
	response = CreateRemoveVpcAccessAndAbolishApisResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveVpcAccessAndAbolishApisWithChan invokes the cloudapi.RemoveVpcAccessAndAbolishApis API asynchronously
func (client *Client) RemoveVpcAccessAndAbolishApisWithChan(request *RemoveVpcAccessAndAbolishApisRequest) (<-chan *RemoveVpcAccessAndAbolishApisResponse, <-chan error) {
	responseChan := make(chan *RemoveVpcAccessAndAbolishApisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveVpcAccessAndAbolishApis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveVpcAccessAndAbolishApisWithCallback invokes the cloudapi.RemoveVpcAccessAndAbolishApis API asynchronously
func (client *Client) RemoveVpcAccessAndAbolishApisWithCallback(request *RemoveVpcAccessAndAbolishApisRequest, callback func(response *RemoveVpcAccessAndAbolishApisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveVpcAccessAndAbolishApisResponse
		var err error
		defer close(result)
		response, err = client.RemoveVpcAccessAndAbolishApis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveVpcAccessAndAbolishApisRequest is the request struct for api RemoveVpcAccessAndAbolishApis
type RemoveVpcAccessAndAbolishApisRequest struct {
	*requests.RpcRequest
	InstanceId    string           `position:"Query" name:"InstanceId"`
	NeedBatchWork requests.Boolean `position:"Query" name:"NeedBatchWork"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	Port          requests.Integer `position:"Query" name:"Port"`
	VpcId         string           `position:"Query" name:"VpcId"`
	VpcAccessId   string           `position:"Query" name:"VpcAccessId"`
}

// RemoveVpcAccessAndAbolishApisResponse is the response struct for api RemoveVpcAccessAndAbolishApis
type RemoveVpcAccessAndAbolishApisResponse struct {
	*responses.BaseResponse
	OperationId string `json:"OperationId" xml:"OperationId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveVpcAccessAndAbolishApisRequest creates a request to invoke RemoveVpcAccessAndAbolishApis API
func CreateRemoveVpcAccessAndAbolishApisRequest() (request *RemoveVpcAccessAndAbolishApisRequest) {
	request = &RemoveVpcAccessAndAbolishApisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "RemoveVpcAccessAndAbolishApis", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveVpcAccessAndAbolishApisResponse creates a response to parse from RemoveVpcAccessAndAbolishApis response
func CreateRemoveVpcAccessAndAbolishApisResponse() (response *RemoveVpcAccessAndAbolishApisResponse) {
	response = &RemoveVpcAccessAndAbolishApisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
