package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableInstanceAccessControl invokes the cloudapi.DisableInstanceAccessControl API synchronously
func (client *Client) DisableInstanceAccessControl(request *DisableInstanceAccessControlRequest) (response *DisableInstanceAccessControlResponse, err error) {
	response = CreateDisableInstanceAccessControlResponse()
	err = client.DoAction(request, response)
	return
}

// DisableInstanceAccessControlWithChan invokes the cloudapi.DisableInstanceAccessControl API asynchronously
func (client *Client) DisableInstanceAccessControlWithChan(request *DisableInstanceAccessControlRequest) (<-chan *DisableInstanceAccessControlResponse, <-chan error) {
	responseChan := make(chan *DisableInstanceAccessControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableInstanceAccessControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableInstanceAccessControlWithCallback invokes the cloudapi.DisableInstanceAccessControl API asynchronously
func (client *Client) DisableInstanceAccessControlWithCallback(request *DisableInstanceAccessControlRequest, callback func(response *DisableInstanceAccessControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableInstanceAccessControlResponse
		var err error
		defer close(result)
		response, err = client.DisableInstanceAccessControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableInstanceAccessControlRequest is the request struct for api DisableInstanceAccessControl
type DisableInstanceAccessControlRequest struct {
	*requests.RpcRequest
	AclId            string `position:"Query" name:"AclId"`
	AddressIPVersion string `position:"Query" name:"AddressIPVersion"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	SecurityToken    string `position:"Query" name:"SecurityToken"`
}

// DisableInstanceAccessControlResponse is the response struct for api DisableInstanceAccessControl
type DisableInstanceAccessControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableInstanceAccessControlRequest creates a request to invoke DisableInstanceAccessControl API
func CreateDisableInstanceAccessControlRequest() (request *DisableInstanceAccessControlRequest) {
	request = &DisableInstanceAccessControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DisableInstanceAccessControl", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableInstanceAccessControlResponse creates a response to parse from DisableInstanceAccessControl response
func CreateDisableInstanceAccessControlResponse() (response *DisableInstanceAccessControlResponse) {
	response = &DisableInstanceAccessControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
