package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApiProductApis invokes the cloudapi.DescribeApiProductApis API synchronously
func (client *Client) DescribeApiProductApis(request *DescribeApiProductApisRequest) (response *DescribeApiProductApisResponse, err error) {
	response = CreateDescribeApiProductApisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApiProductApisWithChan invokes the cloudapi.DescribeApiProductApis API asynchronously
func (client *Client) DescribeApiProductApisWithChan(request *DescribeApiProductApisRequest) (<-chan *DescribeApiProductApisResponse, <-chan error) {
	responseChan := make(chan *DescribeApiProductApisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApiProductApis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApiProductApisWithCallback invokes the cloudapi.DescribeApiProductApis API asynchronously
func (client *Client) DescribeApiProductApisWithCallback(request *DescribeApiProductApisRequest, callback func(response *DescribeApiProductApisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApiProductApisResponse
		var err error
		defer close(result)
		response, err = client.DescribeApiProductApis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApiProductApisRequest is the request struct for api DescribeApiProductApis
type DescribeApiProductApisRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ApiProductId  string           `position:"Query" name:"ApiProductId"`
}

// DescribeApiProductApisResponse is the response struct for api DescribeApiProductApis
type DescribeApiProductApisResponse struct {
	*responses.BaseResponse
	RequestId   string                              `json:"RequestId" xml:"RequestId"`
	PageNumber  int                                 `json:"PageNumber" xml:"PageNumber"`
	PageSize    int                                 `json:"PageSize" xml:"PageSize"`
	TotalCount  int                                 `json:"TotalCount" xml:"TotalCount"`
	ApiInfoList ApiInfoListInDescribeApiProductApis `json:"ApiInfoList" xml:"ApiInfoList"`
}

// CreateDescribeApiProductApisRequest creates a request to invoke DescribeApiProductApis API
func CreateDescribeApiProductApisRequest() (request *DescribeApiProductApisRequest) {
	request = &DescribeApiProductApisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeApiProductApis", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApiProductApisResponse creates a response to parse from DescribeApiProductApis response
func CreateDescribeApiProductApisResponse() (response *DescribeApiProductApisResponse) {
	response = &DescribeApiProductApisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
