package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAbolishApiTask invokes the cloudapi.DescribeAbolishApiTask API synchronously
func (client *Client) DescribeAbolishApiTask(request *DescribeAbolishApiTaskRequest) (response *DescribeAbolishApiTaskResponse, err error) {
	response = CreateDescribeAbolishApiTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAbolishApiTaskWithChan invokes the cloudapi.DescribeAbolishApiTask API asynchronously
func (client *Client) DescribeAbolishApiTaskWithChan(request *DescribeAbolishApiTaskRequest) (<-chan *DescribeAbolishApiTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeAbolishApiTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAbolishApiTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAbolishApiTaskWithCallback invokes the cloudapi.DescribeAbolishApiTask API asynchronously
func (client *Client) DescribeAbolishApiTaskWithCallback(request *DescribeAbolishApiTaskRequest, callback func(response *DescribeAbolishApiTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAbolishApiTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeAbolishApiTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAbolishApiTaskRequest is the request struct for api DescribeAbolishApiTask
type DescribeAbolishApiTaskRequest struct {
	*requests.RpcRequest
	OperationUid  string `position:"Query" name:"OperationUid"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeAbolishApiTaskResponse is the response struct for api DescribeAbolishApiTask
type DescribeAbolishApiTaskResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ApiAbolishResults ApiAbolishResults `json:"ApiAbolishResults" xml:"ApiAbolishResults"`
}

// CreateDescribeAbolishApiTaskRequest creates a request to invoke DescribeAbolishApiTask API
func CreateDescribeAbolishApiTaskRequest() (request *DescribeAbolishApiTaskRequest) {
	request = &DescribeAbolishApiTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeAbolishApiTask", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAbolishApiTaskResponse creates a response to parse from DescribeAbolishApiTask response
func CreateDescribeAbolishApiTaskResponse() (response *DescribeAbolishApiTaskResponse) {
	response = &DescribeAbolishApiTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
