package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIntranetDomain invokes the cloudapi.CreateIntranetDomain API synchronously
func (client *Client) CreateIntranetDomain(request *CreateIntranetDomainRequest) (response *CreateIntranetDomainResponse, err error) {
	response = CreateCreateIntranetDomainResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIntranetDomainWithChan invokes the cloudapi.CreateIntranetDomain API asynchronously
func (client *Client) CreateIntranetDomainWithChan(request *CreateIntranetDomainRequest) (<-chan *CreateIntranetDomainResponse, <-chan error) {
	responseChan := make(chan *CreateIntranetDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIntranetDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIntranetDomainWithCallback invokes the cloudapi.CreateIntranetDomain API asynchronously
func (client *Client) CreateIntranetDomainWithCallback(request *CreateIntranetDomainRequest, callback func(response *CreateIntranetDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIntranetDomainResponse
		var err error
		defer close(result)
		response, err = client.CreateIntranetDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIntranetDomainRequest is the request struct for api CreateIntranetDomain
type CreateIntranetDomainRequest struct {
	*requests.RpcRequest
	GroupId              string           `position:"Query" name:"GroupId"`
	DeleteInternetDomain requests.Boolean `position:"Query" name:"DeleteInternetDomain"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
}

// CreateIntranetDomainResponse is the response struct for api CreateIntranetDomain
type CreateIntranetDomainResponse struct {
	*responses.BaseResponse
	DomainName string `json:"DomainName" xml:"DomainName"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateIntranetDomainRequest creates a request to invoke CreateIntranetDomain API
func CreateCreateIntranetDomainRequest() (request *CreateIntranetDomainRequest) {
	request = &CreateIntranetDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "CreateIntranetDomain", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIntranetDomainResponse creates a response to parse from CreateIntranetDomain response
func CreateCreateIntranetDomainResponse() (response *CreateIntranetDomainResponse) {
	response = &CreateIntranetDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
