package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBindAccount invokes the cloud_siem.ModifyBindAccount API synchronously
func (client *Client) ModifyBindAccount(request *ModifyBindAccountRequest) (response *ModifyBindAccountResponse, err error) {
	response = CreateModifyBindAccountResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBindAccountWithChan invokes the cloud_siem.ModifyBindAccount API asynchronously
func (client *Client) ModifyBindAccountWithChan(request *ModifyBindAccountRequest) (<-chan *ModifyBindAccountResponse, <-chan error) {
	responseChan := make(chan *ModifyBindAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBindAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBindAccountWithCallback invokes the cloud_siem.ModifyBindAccount API asynchronously
func (client *Client) ModifyBindAccountWithCallback(request *ModifyBindAccountRequest, callback func(response *ModifyBindAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBindAccountResponse
		var err error
		defer close(result)
		response, err = client.ModifyBindAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBindAccountRequest is the request struct for api ModifyBindAccount
type ModifyBindAccountRequest struct {
	*requests.RpcRequest
	CloudCode   string           `position:"Body" name:"CloudCode"`
	AccountId   string           `position:"Body" name:"AccountId"`
	AccountName string           `position:"Body" name:"AccountName"`
	BindId      requests.Integer `position:"Body" name:"BindId"`
	AccessId    string           `position:"Body" name:"AccessId"`
}

// ModifyBindAccountResponse is the response struct for api ModifyBindAccount
type ModifyBindAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyBindAccountRequest creates a request to invoke ModifyBindAccount API
func CreateModifyBindAccountRequest() (request *ModifyBindAccountRequest) {
	request = &ModifyBindAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "ModifyBindAccount", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyBindAccountResponse creates a response to parse from ModifyBindAccount response
func CreateModifyBindAccountResponse() (response *ModifyBindAccountResponse) {
	response = &ModifyBindAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
