package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DoQuickField invokes the cloud_siem.DoQuickField API synchronously
func (client *Client) DoQuickField(request *DoQuickFieldRequest) (response *DoQuickFieldResponse, err error) {
	response = CreateDoQuickFieldResponse()
	err = client.DoAction(request, response)
	return
}

// DoQuickFieldWithChan invokes the cloud_siem.DoQuickField API asynchronously
func (client *Client) DoQuickFieldWithChan(request *DoQuickFieldRequest) (<-chan *DoQuickFieldResponse, <-chan error) {
	responseChan := make(chan *DoQuickFieldResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DoQuickField(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DoQuickFieldWithCallback invokes the cloud_siem.DoQuickField API asynchronously
func (client *Client) DoQuickFieldWithCallback(request *DoQuickFieldRequest, callback func(response *DoQuickFieldResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DoQuickFieldResponse
		var err error
		defer close(result)
		response, err = client.DoQuickField(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DoQuickFieldRequest is the request struct for api DoQuickField
type DoQuickFieldRequest struct {
	*requests.RpcRequest
	From    requests.Integer `position:"Body" name:"From"`
	Index   string           `position:"Body" name:"Index"`
	Reverse requests.Boolean `position:"Body" name:"Reverse"`
	Size    requests.Integer `position:"Body" name:"Size"`
	To      requests.Integer `position:"Body" name:"To"`
	Page    requests.Integer `position:"Body" name:"Page"`
}

// DoQuickFieldResponse is the response struct for api DoQuickField
type DoQuickFieldResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDoQuickFieldRequest creates a request to invoke DoQuickField API
func CreateDoQuickFieldRequest() (request *DoQuickFieldRequest) {
	request = &DoQuickFieldRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DoQuickField", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDoQuickFieldResponse creates a response to parse from DoQuickField response
func CreateDoQuickFieldResponse() (response *DoQuickFieldResponse) {
	response = &DoQuickFieldResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
