package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMinorVersionGreadeType invokes the clickhouse.ModifyMinorVersionGreadeType API synchronously
func (client *Client) ModifyMinorVersionGreadeType(request *ModifyMinorVersionGreadeTypeRequest) (response *ModifyMinorVersionGreadeTypeResponse, err error) {
	response = CreateModifyMinorVersionGreadeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMinorVersionGreadeTypeWithChan invokes the clickhouse.ModifyMinorVersionGreadeType API asynchronously
func (client *Client) ModifyMinorVersionGreadeTypeWithChan(request *ModifyMinorVersionGreadeTypeRequest) (<-chan *ModifyMinorVersionGreadeTypeResponse, <-chan error) {
	responseChan := make(chan *ModifyMinorVersionGreadeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMinorVersionGreadeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMinorVersionGreadeTypeWithCallback invokes the clickhouse.ModifyMinorVersionGreadeType API asynchronously
func (client *Client) ModifyMinorVersionGreadeTypeWithCallback(request *ModifyMinorVersionGreadeTypeRequest, callback func(response *ModifyMinorVersionGreadeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMinorVersionGreadeTypeResponse
		var err error
		defer close(result)
		response, err = client.ModifyMinorVersionGreadeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMinorVersionGreadeTypeRequest is the request struct for api ModifyMinorVersionGreadeType
type ModifyMinorVersionGreadeTypeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MaintainAutoType     requests.Boolean `position:"Query" name:"MaintainAutoType"`
}

// ModifyMinorVersionGreadeTypeResponse is the response struct for api ModifyMinorVersionGreadeType
type ModifyMinorVersionGreadeTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyMinorVersionGreadeTypeRequest creates a request to invoke ModifyMinorVersionGreadeType API
func CreateModifyMinorVersionGreadeTypeRequest() (request *ModifyMinorVersionGreadeTypeRequest) {
	request = &ModifyMinorVersionGreadeTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "ModifyMinorVersionGreadeType", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyMinorVersionGreadeTypeResponse creates a response to parse from ModifyMinorVersionGreadeType response
func CreateModifyMinorVersionGreadeTypeResponse() (response *ModifyMinorVersionGreadeTypeResponse) {
	response = &ModifyMinorVersionGreadeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
