package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConfigVersionDifference invokes the clickhouse.DescribeConfigVersionDifference API synchronously
func (client *Client) DescribeConfigVersionDifference(request *DescribeConfigVersionDifferenceRequest) (response *DescribeConfigVersionDifferenceResponse, err error) {
	response = CreateDescribeConfigVersionDifferenceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConfigVersionDifferenceWithChan invokes the clickhouse.DescribeConfigVersionDifference API asynchronously
func (client *Client) DescribeConfigVersionDifferenceWithChan(request *DescribeConfigVersionDifferenceRequest) (<-chan *DescribeConfigVersionDifferenceResponse, <-chan error) {
	responseChan := make(chan *DescribeConfigVersionDifferenceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConfigVersionDifference(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConfigVersionDifferenceWithCallback invokes the clickhouse.DescribeConfigVersionDifference API asynchronously
func (client *Client) DescribeConfigVersionDifferenceWithCallback(request *DescribeConfigVersionDifferenceRequest, callback func(response *DescribeConfigVersionDifferenceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConfigVersionDifferenceResponse
		var err error
		defer close(result)
		response, err = client.DescribeConfigVersionDifference(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConfigVersionDifferenceRequest is the request struct for api DescribeConfigVersionDifference
type DescribeConfigVersionDifferenceRequest struct {
	*requests.RpcRequest
	DBClusterId string `position:"Query" name:"DBClusterId"`
	ChangeId    string `position:"Query" name:"ChangeId"`
}

// DescribeConfigVersionDifferenceResponse is the response struct for api DescribeConfigVersionDifference
type DescribeConfigVersionDifferenceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	OldConfigXML string `json:"OldConfigXML" xml:"OldConfigXML"`
	NewConfigXML string `json:"NewConfigXML" xml:"NewConfigXML"`
}

// CreateDescribeConfigVersionDifferenceRequest creates a request to invoke DescribeConfigVersionDifference API
func CreateDescribeConfigVersionDifferenceRequest() (request *DescribeConfigVersionDifferenceRequest) {
	request = &DescribeConfigVersionDifferenceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeConfigVersionDifference", "service", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeConfigVersionDifferenceResponse creates a response to parse from DescribeConfigVersionDifference response
func CreateDescribeConfigVersionDifferenceResponse() (response *DescribeConfigVersionDifferenceResponse) {
	response = &DescribeConfigVersionDifferenceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
