package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePreloadDetailById invokes the cdn.DescribePreloadDetailById API synchronously
func (client *Client) DescribePreloadDetailById(request *DescribePreloadDetailByIdRequest) (response *DescribePreloadDetailByIdResponse, err error) {
	response = CreateDescribePreloadDetailByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePreloadDetailByIdWithChan invokes the cdn.DescribePreloadDetailById API asynchronously
func (client *Client) DescribePreloadDetailByIdWithChan(request *DescribePreloadDetailByIdRequest) (<-chan *DescribePreloadDetailByIdResponse, <-chan error) {
	responseChan := make(chan *DescribePreloadDetailByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePreloadDetailById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePreloadDetailByIdWithCallback invokes the cdn.DescribePreloadDetailById API asynchronously
func (client *Client) DescribePreloadDetailByIdWithCallback(request *DescribePreloadDetailByIdRequest, callback func(response *DescribePreloadDetailByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePreloadDetailByIdResponse
		var err error
		defer close(result)
		response, err = client.DescribePreloadDetailById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePreloadDetailByIdRequest is the request struct for api DescribePreloadDetailById
type DescribePreloadDetailByIdRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Query" name:"TaskId"`
}

// DescribePreloadDetailByIdResponse is the response struct for api DescribePreloadDetailById
type DescribePreloadDetailByIdResponse struct {
	*responses.BaseResponse
	TotalCount int64       `json:"TotalCount" xml:"TotalCount"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	UrlDetails []UrlDetail `json:"UrlDetails" xml:"UrlDetails"`
}

// CreateDescribePreloadDetailByIdRequest creates a request to invoke DescribePreloadDetailById API
func CreateDescribePreloadDetailByIdRequest() (request *DescribePreloadDetailByIdRequest) {
	request = &DescribePreloadDetailByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribePreloadDetailById", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePreloadDetailByIdResponse creates a response to parse from DescribePreloadDetailById response
func CreateDescribePreloadDetailByIdResponse() (response *DescribePreloadDetailByIdResponse) {
	response = &DescribePreloadDetailByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
