package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHistoricalCallerReport invokes the ccc.GetHistoricalCallerReport API synchronously
func (client *Client) GetHistoricalCallerReport(request *GetHistoricalCallerReportRequest) (response *GetHistoricalCallerReportResponse, err error) {
	response = CreateGetHistoricalCallerReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetHistoricalCallerReportWithChan invokes the ccc.GetHistoricalCallerReport API asynchronously
func (client *Client) GetHistoricalCallerReportWithChan(request *GetHistoricalCallerReportRequest) (<-chan *GetHistoricalCallerReportResponse, <-chan error) {
	responseChan := make(chan *GetHistoricalCallerReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHistoricalCallerReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHistoricalCallerReportWithCallback invokes the ccc.GetHistoricalCallerReport API asynchronously
func (client *Client) GetHistoricalCallerReportWithCallback(request *GetHistoricalCallerReportRequest, callback func(response *GetHistoricalCallerReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHistoricalCallerReportResponse
		var err error
		defer close(result)
		response, err = client.GetHistoricalCallerReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHistoricalCallerReportRequest is the request struct for api GetHistoricalCallerReport
type GetHistoricalCallerReportRequest struct {
	*requests.RpcRequest
	StopTime      requests.Integer `position:"Query" name:"StopTime"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	CallingNumber string           `position:"Query" name:"CallingNumber"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
}

// GetHistoricalCallerReportResponse is the response struct for api GetHistoricalCallerReport
type GetHistoricalCallerReportResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetHistoricalCallerReportRequest creates a request to invoke GetHistoricalCallerReport API
func CreateGetHistoricalCallerReportRequest() (request *GetHistoricalCallerReportRequest) {
	request = &GetHistoricalCallerReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetHistoricalCallerReport", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetHistoricalCallerReportResponse creates a response to parse from GetHistoricalCallerReport response
func CreateGetHistoricalCallerReportResponse() (response *GetHistoricalCallerReportResponse) {
	response = &GetHistoricalCallerReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
