package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDNSAuthorizationRule invokes the cc5g.UpdateDNSAuthorizationRule API synchronously
func (client *Client) UpdateDNSAuthorizationRule(request *UpdateDNSAuthorizationRuleRequest) (response *UpdateDNSAuthorizationRuleResponse, err error) {
	response = CreateUpdateDNSAuthorizationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDNSAuthorizationRuleWithChan invokes the cc5g.UpdateDNSAuthorizationRule API asynchronously
func (client *Client) UpdateDNSAuthorizationRuleWithChan(request *UpdateDNSAuthorizationRuleRequest) (<-chan *UpdateDNSAuthorizationRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateDNSAuthorizationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDNSAuthorizationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDNSAuthorizationRuleWithCallback invokes the cc5g.UpdateDNSAuthorizationRule API asynchronously
func (client *Client) UpdateDNSAuthorizationRuleWithCallback(request *UpdateDNSAuthorizationRuleRequest, callback func(response *UpdateDNSAuthorizationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDNSAuthorizationRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateDNSAuthorizationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDNSAuthorizationRuleRequest is the request struct for api UpdateDNSAuthorizationRule
type UpdateDNSAuthorizationRuleRequest struct {
	*requests.RpcRequest
	ClientToken              string           `position:"Query" name:"ClientToken"`
	Description              string           `position:"Query" name:"Description"`
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	SourceDNSIp              string           `position:"Query" name:"SourceDNSIp"`
	AuthorizationRuleId      string           `position:"Query" name:"AuthorizationRuleId"`
	DestinationIp            string           `position:"Query" name:"DestinationIp"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	Name                     string           `position:"Query" name:"Name"`
}

// UpdateDNSAuthorizationRuleResponse is the response struct for api UpdateDNSAuthorizationRule
type UpdateDNSAuthorizationRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDNSAuthorizationRuleRequest creates a request to invoke UpdateDNSAuthorizationRule API
func CreateUpdateDNSAuthorizationRuleRequest() (request *UpdateDNSAuthorizationRuleRequest) {
	request = &UpdateDNSAuthorizationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "UpdateDNSAuthorizationRule", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDNSAuthorizationRuleResponse creates a response to parse from UpdateDNSAuthorizationRule response
func CreateUpdateDNSAuthorizationRuleResponse() (response *UpdateDNSAuthorizationRuleResponse) {
	response = &UpdateDNSAuthorizationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
