package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIoTCloudConnectorBackhaulRoute invokes the cc5g.ListIoTCloudConnectorBackhaulRoute API synchronously
func (client *Client) ListIoTCloudConnectorBackhaulRoute(request *ListIoTCloudConnectorBackhaulRouteRequest) (response *ListIoTCloudConnectorBackhaulRouteResponse, err error) {
	response = CreateListIoTCloudConnectorBackhaulRouteResponse()
	err = client.DoAction(request, response)
	return
}

// ListIoTCloudConnectorBackhaulRouteWithChan invokes the cc5g.ListIoTCloudConnectorBackhaulRoute API asynchronously
func (client *Client) ListIoTCloudConnectorBackhaulRouteWithChan(request *ListIoTCloudConnectorBackhaulRouteRequest) (<-chan *ListIoTCloudConnectorBackhaulRouteResponse, <-chan error) {
	responseChan := make(chan *ListIoTCloudConnectorBackhaulRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIoTCloudConnectorBackhaulRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIoTCloudConnectorBackhaulRouteWithCallback invokes the cc5g.ListIoTCloudConnectorBackhaulRoute API asynchronously
func (client *Client) ListIoTCloudConnectorBackhaulRouteWithCallback(request *ListIoTCloudConnectorBackhaulRouteRequest, callback func(response *ListIoTCloudConnectorBackhaulRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIoTCloudConnectorBackhaulRouteResponse
		var err error
		defer close(result)
		response, err = client.ListIoTCloudConnectorBackhaulRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIoTCloudConnectorBackhaulRouteRequest is the request struct for api ListIoTCloudConnectorBackhaulRoute
type ListIoTCloudConnectorBackhaulRouteRequest struct {
	*requests.RpcRequest
	NetLinkId                string `position:"Query" name:"NetLinkId"`
	WirelessCloudConnectorId string `position:"Query" name:"WirelessCloudConnectorId"`
}

// ListIoTCloudConnectorBackhaulRouteResponse is the response struct for api ListIoTCloudConnectorBackhaulRoute
type ListIoTCloudConnectorBackhaulRouteResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	NetLinkId string       `json:"NetLinkId" xml:"NetLinkId"`
	Routes    []RouteEntry `json:"Routes" xml:"Routes"`
}

// CreateListIoTCloudConnectorBackhaulRouteRequest creates a request to invoke ListIoTCloudConnectorBackhaulRoute API
func CreateListIoTCloudConnectorBackhaulRouteRequest() (request *ListIoTCloudConnectorBackhaulRouteRequest) {
	request = &ListIoTCloudConnectorBackhaulRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListIoTCloudConnectorBackhaulRoute", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListIoTCloudConnectorBackhaulRouteResponse creates a response to parse from ListIoTCloudConnectorBackhaulRoute response
func CreateListIoTCloudConnectorBackhaulRouteResponse() (response *ListIoTCloudConnectorBackhaulRouteResponse) {
	response = &ListIoTCloudConnectorBackhaulRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
