package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCard invokes the cc5g.GetCard API synchronously
func (client *Client) GetCard(request *GetCardRequest) (response *GetCardResponse, err error) {
	response = CreateGetCardResponse()
	err = client.DoAction(request, response)
	return
}

// GetCardWithChan invokes the cc5g.GetCard API asynchronously
func (client *Client) GetCardWithChan(request *GetCardRequest) (<-chan *GetCardResponse, <-chan error) {
	responseChan := make(chan *GetCardResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCard(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCardWithCallback invokes the cc5g.GetCard API asynchronously
func (client *Client) GetCardWithCallback(request *GetCardRequest, callback func(response *GetCardResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCardResponse
		var err error
		defer close(result)
		response, err = client.GetCard(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCardRequest is the request struct for api GetCard
type GetCardRequest struct {
	*requests.RpcRequest
	Iccid string `position:"Query" name:"Iccid"`
}

// GetCardResponse is the response struct for api GetCard
type GetCardResponse struct {
	*responses.BaseResponse
	RequestId                string `json:"RequestId" xml:"RequestId"`
	Iccid                    string `json:"Iccid" xml:"Iccid"`
	NetType                  string `json:"NetType" xml:"NetType"`
	APN                      string `json:"APN" xml:"APN"`
	ISP                      string `json:"ISP" xml:"ISP"`
	IpAddress                string `json:"IpAddress" xml:"IpAddress"`
	Imsi                     string `json:"Imsi" xml:"Imsi"`
	Imei                     string `json:"Imei" xml:"Imei"`
	Lock                     string `json:"Lock" xml:"Lock"`
	Spec                     string `json:"Spec" xml:"Spec"`
	SimStatus                string `json:"SimStatus" xml:"SimStatus"`
	Status                   string `json:"Status" xml:"Status"`
	Description              string `json:"Description" xml:"Description"`
	Name                     string `json:"Name" xml:"Name"`
	WirelessCloudConnectorId string `json:"WirelessCloudConnectorId" xml:"WirelessCloudConnectorId"`
	CloudConnectorId         string `json:"CloudConnectorId" xml:"CloudConnectorId"`
	UsageDataMonth           int    `json:"UsageDataMonth" xml:"UsageDataMonth"`
	OrderId                  string `json:"OrderId" xml:"OrderId"`
	ActivatedTime            string `json:"ActivatedTime" xml:"ActivatedTime"`
	Msisdn                   string `json:"Msisdn" xml:"Msisdn"`
	UsageDataTotal           int64  `json:"UsageDataTotal" xml:"UsageDataTotal"`
	LimitThreshold           int64  `json:"LimitThreshold" xml:"LimitThreshold"`
	StopThreshold            int64  `json:"StopThreshold" xml:"StopThreshold"`
	AlarmThreshold           int64  `json:"AlarmThreshold" xml:"AlarmThreshold"`
}

// CreateGetCardRequest creates a request to invoke GetCard API
func CreateGetCardRequest() (request *GetCardRequest) {
	request = &GetCardRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "GetCard", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetCardResponse creates a response to parse from GetCard response
func CreateGetCardResponse() (response *GetCardResponse) {
	response = &GetCardResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
