package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTransitRouterRouteEntry invokes the cbn.UpdateTransitRouterRouteEntry API synchronously
func (client *Client) UpdateTransitRouterRouteEntry(request *UpdateTransitRouterRouteEntryRequest) (response *UpdateTransitRouterRouteEntryResponse, err error) {
	response = CreateUpdateTransitRouterRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTransitRouterRouteEntryWithChan invokes the cbn.UpdateTransitRouterRouteEntry API asynchronously
func (client *Client) UpdateTransitRouterRouteEntryWithChan(request *UpdateTransitRouterRouteEntryRequest) (<-chan *UpdateTransitRouterRouteEntryResponse, <-chan error) {
	responseChan := make(chan *UpdateTransitRouterRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTransitRouterRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTransitRouterRouteEntryWithCallback invokes the cbn.UpdateTransitRouterRouteEntry API asynchronously
func (client *Client) UpdateTransitRouterRouteEntryWithCallback(request *UpdateTransitRouterRouteEntryRequest, callback func(response *UpdateTransitRouterRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTransitRouterRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.UpdateTransitRouterRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTransitRouterRouteEntryRequest is the request struct for api UpdateTransitRouterRouteEntry
type UpdateTransitRouterRouteEntryRequest struct {
	*requests.RpcRequest
	TransitRouterRouteEntryId          string           `position:"Query" name:"TransitRouterRouteEntryId"`
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                        string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteEntryDescription string           `position:"Query" name:"TransitRouterRouteEntryDescription"`
	DryRun                             requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterRouteEntryName        string           `position:"Query" name:"TransitRouterRouteEntryName"`
	Version                            string           `position:"Query" name:"Version"`
}

// UpdateTransitRouterRouteEntryResponse is the response struct for api UpdateTransitRouterRouteEntry
type UpdateTransitRouterRouteEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTransitRouterRouteEntryRequest creates a request to invoke UpdateTransitRouterRouteEntry API
func CreateUpdateTransitRouterRouteEntryRequest() (request *UpdateTransitRouterRouteEntryRequest) {
	request = &UpdateTransitRouterRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UpdateTransitRouterRouteEntry", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTransitRouterRouteEntryResponse creates a response to parse from UpdateTransitRouterRouteEntry response
func CreateUpdateTransitRouterRouteEntryResponse() (response *UpdateTransitRouterRouteEntryResponse) {
	response = &UpdateTransitRouterRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
