package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGrantRulesToResource invokes the cbn.DescribeGrantRulesToResource API synchronously
func (client *Client) DescribeGrantRulesToResource(request *DescribeGrantRulesToResourceRequest) (response *DescribeGrantRulesToResourceResponse, err error) {
	response = CreateDescribeGrantRulesToResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGrantRulesToResourceWithChan invokes the cbn.DescribeGrantRulesToResource API asynchronously
func (client *Client) DescribeGrantRulesToResourceWithChan(request *DescribeGrantRulesToResourceRequest) (<-chan *DescribeGrantRulesToResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeGrantRulesToResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGrantRulesToResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGrantRulesToResourceWithCallback invokes the cbn.DescribeGrantRulesToResource API asynchronously
func (client *Client) DescribeGrantRulesToResourceWithCallback(request *DescribeGrantRulesToResourceRequest, callback func(response *DescribeGrantRulesToResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGrantRulesToResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeGrantRulesToResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGrantRulesToResourceRequest is the request struct for api DescribeGrantRulesToResource
type DescribeGrantRulesToResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ProductType          string           `position:"Query" name:"ProductType"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceId           string           `position:"Query" name:"ResourceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeGrantRulesToResourceResponse is the response struct for api DescribeGrantRulesToResource
type DescribeGrantRulesToResourceResponse struct {
	*responses.BaseResponse
	NextToken  string                                    `json:"NextToken" xml:"NextToken"`
	RequestId  string                                    `json:"RequestId" xml:"RequestId"`
	TotalCount int                                       `json:"TotalCount" xml:"TotalCount"`
	MaxResults int                                       `json:"MaxResults" xml:"MaxResults"`
	GrantRules []GrantRuleInDescribeGrantRulesToResource `json:"GrantRules" xml:"GrantRules"`
}

// CreateDescribeGrantRulesToResourceRequest creates a request to invoke DescribeGrantRulesToResource API
func CreateDescribeGrantRulesToResourceRequest() (request *DescribeGrantRulesToResourceRequest) {
	request = &DescribeGrantRulesToResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeGrantRulesToResource", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGrantRulesToResourceResponse creates a response to parse from DescribeGrantRulesToResource response
func CreateDescribeGrantRulesToResourceResponse() (response *DescribeGrantRulesToResourceResponse) {
	response = &DescribeGrantRulesToResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
