package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataCenters invokes the cassandra.DescribeDataCenters API synchronously
func (client *Client) DescribeDataCenters(request *DescribeDataCentersRequest) (response *DescribeDataCentersResponse, err error) {
	response = CreateDescribeDataCentersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataCentersWithChan invokes the cassandra.DescribeDataCenters API asynchronously
func (client *Client) DescribeDataCentersWithChan(request *DescribeDataCentersRequest) (<-chan *DescribeDataCentersResponse, <-chan error) {
	responseChan := make(chan *DescribeDataCentersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataCenters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataCentersWithCallback invokes the cassandra.DescribeDataCenters API asynchronously
func (client *Client) DescribeDataCentersWithCallback(request *DescribeDataCentersRequest, callback func(response *DescribeDataCentersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataCentersResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataCenters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataCentersRequest is the request struct for api DescribeDataCenters
type DescribeDataCentersRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeDataCentersResponse is the response struct for api DescribeDataCenters
type DescribeDataCentersResponse struct {
	*responses.BaseResponse
	RequestId   string                           `json:"RequestId" xml:"RequestId"`
	DataCenters DataCentersInDescribeDataCenters `json:"DataCenters" xml:"DataCenters"`
}

// CreateDescribeDataCentersRequest creates a request to invoke DescribeDataCenters API
func CreateDescribeDataCentersRequest() (request *DescribeDataCentersRequest) {
	request = &DescribeDataCentersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeDataCenters", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDataCentersResponse creates a response to parse from DescribeDataCenters response
func CreateDescribeDataCentersResponse() (response *DescribeDataCentersResponse) {
	response = &DescribeDataCentersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
