package bpstudio

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteOperationASync invokes the bpstudio.ExecuteOperationASync API synchronously
func (client *Client) ExecuteOperationASync(request *ExecuteOperationASyncRequest) (response *ExecuteOperationASyncResponse, err error) {
	response = CreateExecuteOperationASyncResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteOperationASyncWithChan invokes the bpstudio.ExecuteOperationASync API asynchronously
func (client *Client) ExecuteOperationASyncWithChan(request *ExecuteOperationASyncRequest) (<-chan *ExecuteOperationASyncResponse, <-chan error) {
	responseChan := make(chan *ExecuteOperationASyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteOperationASync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteOperationASyncWithCallback invokes the bpstudio.ExecuteOperationASync API asynchronously
func (client *Client) ExecuteOperationASyncWithCallback(request *ExecuteOperationASyncRequest, callback func(response *ExecuteOperationASyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteOperationASyncResponse
		var err error
		defer close(result)
		response, err = client.ExecuteOperationASync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteOperationASyncRequest is the request struct for api ExecuteOperationASync
type ExecuteOperationASyncRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Body" name:"ResourceGroupId"`
	ServiceType     string `position:"Body" name:"ServiceType"`
	Attributes      string `position:"Body" name:"Attributes"`
	Operation       string `position:"Body" name:"Operation"`
}

// ExecuteOperationASyncResponse is the response struct for api ExecuteOperationASync
type ExecuteOperationASyncResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateExecuteOperationASyncRequest creates a request to invoke ExecuteOperationASync API
func CreateExecuteOperationASyncRequest() (request *ExecuteOperationASyncRequest) {
	request = &ExecuteOperationASyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BPStudio", "2021-09-31", "ExecuteOperationASync", "bpstudio", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExecuteOperationASyncResponse creates a response to parse from ExecuteOperationASync response
func CreateExecuteOperationASyncResponse() (response *ExecuteOperationASyncResponse) {
	response = &ExecuteOperationASyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
