package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccessorDomainWhiteList invokes the beian.QueryAccessorDomainWhiteList API synchronously
func (client *Client) QueryAccessorDomainWhiteList(request *QueryAccessorDomainWhiteListRequest) (response *QueryAccessorDomainWhiteListResponse, err error) {
	response = CreateQueryAccessorDomainWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccessorDomainWhiteListWithChan invokes the beian.QueryAccessorDomainWhiteList API asynchronously
func (client *Client) QueryAccessorDomainWhiteListWithChan(request *QueryAccessorDomainWhiteListRequest) (<-chan *QueryAccessorDomainWhiteListResponse, <-chan error) {
	responseChan := make(chan *QueryAccessorDomainWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccessorDomainWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccessorDomainWhiteListWithCallback invokes the beian.QueryAccessorDomainWhiteList API asynchronously
func (client *Client) QueryAccessorDomainWhiteListWithCallback(request *QueryAccessorDomainWhiteListRequest, callback func(response *QueryAccessorDomainWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccessorDomainWhiteListResponse
		var err error
		defer close(result)
		response, err = client.QueryAccessorDomainWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccessorDomainWhiteListRequest is the request struct for api QueryAccessorDomainWhiteList
type QueryAccessorDomainWhiteListRequest struct {
	*requests.RpcRequest
	Caller string `position:"Query" name:"Caller"`
	Domain string `position:"Query" name:"Domain"`
}

// QueryAccessorDomainWhiteListResponse is the response struct for api QueryAccessorDomainWhiteList
type QueryAccessorDomainWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryAccessorDomainWhiteListRequest creates a request to invoke QueryAccessorDomainWhiteList API
func CreateQueryAccessorDomainWhiteListRequest() (request *QueryAccessorDomainWhiteListRequest) {
	request = &QueryAccessorDomainWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "QueryAccessorDomainWhiteList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAccessorDomainWhiteListResponse creates a response to parse from QueryAccessorDomainWhiteList response
func CreateQueryAccessorDomainWhiteListResponse() (response *QueryAccessorDomainWhiteListResponse) {
	response = &QueryAccessorDomainWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
