package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUnbeianIpCheckType invokes the beian.ListUnbeianIpCheckType API synchronously
func (client *Client) ListUnbeianIpCheckType(request *ListUnbeianIpCheckTypeRequest) (response *ListUnbeianIpCheckTypeResponse, err error) {
	response = CreateListUnbeianIpCheckTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ListUnbeianIpCheckTypeWithChan invokes the beian.ListUnbeianIpCheckType API asynchronously
func (client *Client) ListUnbeianIpCheckTypeWithChan(request *ListUnbeianIpCheckTypeRequest) (<-chan *ListUnbeianIpCheckTypeResponse, <-chan error) {
	responseChan := make(chan *ListUnbeianIpCheckTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUnbeianIpCheckType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUnbeianIpCheckTypeWithCallback invokes the beian.ListUnbeianIpCheckType API asynchronously
func (client *Client) ListUnbeianIpCheckTypeWithCallback(request *ListUnbeianIpCheckTypeRequest, callback func(response *ListUnbeianIpCheckTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUnbeianIpCheckTypeResponse
		var err error
		defer close(result)
		response, err = client.ListUnbeianIpCheckType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUnbeianIpCheckTypeRequest is the request struct for api ListUnbeianIpCheckType
type ListUnbeianIpCheckTypeRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	Remark    string           `position:"Query" name:"Remark"`
	CheckType requests.Integer `position:"Query" name:"CheckType"`
	Caller    string           `position:"Query" name:"Caller"`
	Limit     requests.Integer `position:"Query" name:"Limit"`
	Page      requests.Integer `position:"Query" name:"Page"`
}

// ListUnbeianIpCheckTypeResponse is the response struct for api ListUnbeianIpCheckType
type ListUnbeianIpCheckTypeResponse struct {
	*responses.BaseResponse
	ErrorMessage                string                                              `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId                   string                                              `json:"RequestId" xml:"RequestId"`
	Success                     bool                                                `json:"Success" xml:"Success"`
	ErrorCode                   int                                                 `json:"ErrorCode" xml:"ErrorCode"`
	HuntressIpCheckTypeResultDO HuntressIpCheckTypeResultDOInListUnbeianIpCheckType `json:"HuntressIpCheckTypeResultDO" xml:"HuntressIpCheckTypeResultDO"`
}

// CreateListUnbeianIpCheckTypeRequest creates a request to invoke ListUnbeianIpCheckType API
func CreateListUnbeianIpCheckTypeRequest() (request *ListUnbeianIpCheckTypeRequest) {
	request = &ListUnbeianIpCheckTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "ListUnbeianIpCheckType", "", "")
	request.Method = requests.POST
	return
}

// CreateListUnbeianIpCheckTypeResponse creates a response to parse from ListUnbeianIpCheckType response
func CreateListUnbeianIpCheckTypeResponse() (response *ListUnbeianIpCheckTypeResponse) {
	response = &ListUnbeianIpCheckTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
