package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUnbeianIpCheckType invokes the beian.DeleteUnbeianIpCheckType API synchronously
func (client *Client) DeleteUnbeianIpCheckType(request *DeleteUnbeianIpCheckTypeRequest) (response *DeleteUnbeianIpCheckTypeResponse, err error) {
	response = CreateDeleteUnbeianIpCheckTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUnbeianIpCheckTypeWithChan invokes the beian.DeleteUnbeianIpCheckType API asynchronously
func (client *Client) DeleteUnbeianIpCheckTypeWithChan(request *DeleteUnbeianIpCheckTypeRequest) (<-chan *DeleteUnbeianIpCheckTypeResponse, <-chan error) {
	responseChan := make(chan *DeleteUnbeianIpCheckTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUnbeianIpCheckType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUnbeianIpCheckTypeWithCallback invokes the beian.DeleteUnbeianIpCheckType API asynchronously
func (client *Client) DeleteUnbeianIpCheckTypeWithCallback(request *DeleteUnbeianIpCheckTypeRequest, callback func(response *DeleteUnbeianIpCheckTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUnbeianIpCheckTypeResponse
		var err error
		defer close(result)
		response, err = client.DeleteUnbeianIpCheckType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUnbeianIpCheckTypeRequest is the request struct for api DeleteUnbeianIpCheckType
type DeleteUnbeianIpCheckTypeRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	Remark    string           `position:"Query" name:"Remark"`
	CheckType requests.Integer `position:"Query" name:"CheckType"`
	Caller    string           `position:"Query" name:"Caller"`
}

// DeleteUnbeianIpCheckTypeResponse is the response struct for api DeleteUnbeianIpCheckType
type DeleteUnbeianIpCheckTypeResponse struct {
	*responses.BaseResponse
	ErrorMessage                string                      `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId                   string                      `json:"RequestId" xml:"RequestId"`
	Success                     bool                        `json:"Success" xml:"Success"`
	ErrorCode                   int                         `json:"ErrorCode" xml:"ErrorCode"`
	HuntressIpCheckTypeResultDO HuntressIpCheckTypeResultDO `json:"HuntressIpCheckTypeResultDO" xml:"HuntressIpCheckTypeResultDO"`
}

// CreateDeleteUnbeianIpCheckTypeRequest creates a request to invoke DeleteUnbeianIpCheckType API
func CreateDeleteUnbeianIpCheckTypeRequest() (request *DeleteUnbeianIpCheckTypeRequest) {
	request = &DeleteUnbeianIpCheckTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "DeleteUnbeianIpCheckType", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteUnbeianIpCheckTypeResponse creates a response to parse from DeleteUnbeianIpCheckType response
func CreateDeleteUnbeianIpCheckTypeResponse() (response *DeleteUnbeianIpCheckTypeResponse) {
	response = &DeleteUnbeianIpCheckTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
