package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricConsortiumMembers invokes the baas.DescribeFabricConsortiumMembers API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiummembers.html
func (client *Client) DescribeFabricConsortiumMembers(request *DescribeFabricConsortiumMembersRequest) (response *DescribeFabricConsortiumMembersResponse, err error) {
	response = CreateDescribeFabricConsortiumMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricConsortiumMembersWithChan invokes the baas.DescribeFabricConsortiumMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiummembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumMembersWithChan(request *DescribeFabricConsortiumMembersRequest) (<-chan *DescribeFabricConsortiumMembersResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricConsortiumMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricConsortiumMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricConsortiumMembersWithCallback invokes the baas.DescribeFabricConsortiumMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiummembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumMembersWithCallback(request *DescribeFabricConsortiumMembersRequest, callback func(response *DescribeFabricConsortiumMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricConsortiumMembersResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricConsortiumMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricConsortiumMembersRequest is the request struct for api DescribeFabricConsortiumMembers
type DescribeFabricConsortiumMembersRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Body" name:"ConsortiumId"`
}

// DescribeFabricConsortiumMembersResponse is the response struct for api DescribeFabricConsortiumMembers
type DescribeFabricConsortiumMembersResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Success   bool                       `json:"Success" xml:"Success"`
	ErrorCode int                        `json:"ErrorCode" xml:"ErrorCode"`
	Result    []DescribeConsortiumMember `json:"Result" xml:"Result"`
}

// CreateDescribeFabricConsortiumMembersRequest creates a request to invoke DescribeFabricConsortiumMembers API
func CreateDescribeFabricConsortiumMembersRequest() (request *DescribeFabricConsortiumMembersRequest) {
	request = &DescribeFabricConsortiumMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricConsortiumMembers", "baas", "openAPI")
	return
}

// CreateDescribeFabricConsortiumMembersResponse creates a response to parse from DescribeFabricConsortiumMembers response
func CreateDescribeFabricConsortiumMembersResponse() (response *DescribeFabricConsortiumMembersResponse) {
	response = &DescribeFabricConsortiumMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
