package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAntChainContractProject invokes the baas.DeleteAntChainContractProject API synchronously
// api document: https://help.aliyun.com/api/baas/deleteantchaincontractproject.html
func (client *Client) DeleteAntChainContractProject(request *DeleteAntChainContractProjectRequest) (response *DeleteAntChainContractProjectResponse, err error) {
	response = CreateDeleteAntChainContractProjectResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAntChainContractProjectWithChan invokes the baas.DeleteAntChainContractProject API asynchronously
// api document: https://help.aliyun.com/api/baas/deleteantchaincontractproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAntChainContractProjectWithChan(request *DeleteAntChainContractProjectRequest) (<-chan *DeleteAntChainContractProjectResponse, <-chan error) {
	responseChan := make(chan *DeleteAntChainContractProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAntChainContractProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAntChainContractProjectWithCallback invokes the baas.DeleteAntChainContractProject API asynchronously
// api document: https://help.aliyun.com/api/baas/deleteantchaincontractproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAntChainContractProjectWithCallback(request *DeleteAntChainContractProjectRequest, callback func(response *DeleteAntChainContractProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAntChainContractProjectResponse
		var err error
		defer close(result)
		response, err = client.DeleteAntChainContractProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAntChainContractProjectRequest is the request struct for api DeleteAntChainContractProject
type DeleteAntChainContractProjectRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
}

// DeleteAntChainContractProjectResponse is the response struct for api DeleteAntChainContractProject
type DeleteAntChainContractProjectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDeleteAntChainContractProjectRequest creates a request to invoke DeleteAntChainContractProject API
func CreateDeleteAntChainContractProjectRequest() (request *DeleteAntChainContractProjectRequest) {
	request = &DeleteAntChainContractProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DeleteAntChainContractProject", "baas", "openAPI")
	return
}

// CreateDeleteAntChainContractProjectResponse creates a response to parse from DeleteAntChainContractProject response
func CreateDeleteAntChainContractProjectResponse() (response *DeleteAntChainContractProjectResponse) {
	response = &DeleteAntChainContractProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
